package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderAddressDto;
import com.ekingwin.bas.cloud.dto.IpOrderInstidDto;
import com.ekingwin.bas.cloud.dto.IpOrderSearchDto;
import com.ekingwin.bas.cloud.entity.IpcOrder;
import com.ekingwin.bas.cloud.entity.IpcOrderWithBLOBs;
import com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo;
import com.ekingwin.bas.cloud.vo.IpOrderListVo;
import com.ekingwin.bas.cloud.vo.IpOrderMyListVo;
import com.ekingwin.bas.cloud.vo.IsendDeliverMailVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface IpcOrderMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpcOrderWithBLOBs record);

    int insertSelective(IpcOrderWithBLOBs record);

    IpcOrderWithBLOBs selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpcOrderWithBLOBs record);

    int updateByPrimaryKeyWithBLOBs(IpcOrderWithBLOBs record);

    int updateByPrimaryKey(IpcOrder record);


    /**
     * 根据当前登录人查询订单
     * @param ipOrderSearchDto
     * @return
     */
    List<IpOrderListVo> selectInputperson(IpOrderSearchDto ipOrderSearchDto);

    /**
     * 根据供应商查询订单
     * @param ipOrderSearchDto
     * @return
     */
    List<IpOrderListVo> selectBySuppliers(IpOrderSearchDto ipOrderSearchDto);

    /**
     * 根据供应商查询订单
     * @param
     * @return
     */
    List<Map<String,Object>> selectSuppliers(IpOrderMyListVo ipOrderMyListVo);
    /**
     * 根据查询goods信息订单
     * @param
     * @return
     */
    List<Map<String,Object>> selectGoodsInfo(IpOrderMyListVo ipOrderMyListVo);
    /**
     * 根据查询goods详细信息
     * @param
     * @return
     */
    List<Map<String,Object>> selectGoodsDetail(@Param(value = "businessUrl")String businessUrl, @Param(value = "goodsid")String goodsid,
                                               @Param(value = "imgurl")String imgurl );

    /**
     * 维护更新流程实例号
     * @param ipOrderInstidDto
     * @return
     */
    int updateOrderBpmId(IpOrderInstidDto ipOrderInstidDto);

    /**
     * 根据流程实例号获取数据
     * @param instid
     * @return
     */
    IpcOrderWithBLOBs selectByInstid(String instid);

    /**
     * 修改审批单的状态
     * @param instid
     * @return
     */
    int updateOrderInstid(@Param(value = "instid") String instid, @Param(value = "status") String status);


    /**
     * 订单1取消
     * @param orderId
     * @return
     */
    int updateOrderByOrderId(@Param(value = "orderId") Long orderId, @Param(value = "status") String status);

    /**
     * 根据订单号获取订单信息和商品信息
     * @param orderNum
     * @return
     */
    IsendDeliverMailVo getOrderGoodsInfoByOrderNum(@Param(value = "orderNum") String orderNum);


    /**
    * 获取所有的地址信息
    * @Param:  * @param userId
    * @return: java.util.List<com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo>
    * @Author: zhangjie
    * @Date: 2019/10/22 16:18
    */
    List<IpCustOrderAddressVo> getAddressByUserId(IpOrderAddressDto orderAddressDto);
}