package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: IpInvoiceDto
 * @Author: liujunfeng
 * @Date: 2019/11/22 9:50
 * @description:
 */
@Data
@ApiModel("新增发票记录")
public class IpInvoiceDto extends BasDto{

    @ApiModelProperty(value = "id",required = false)
    private Long id;

    @ApiModelProperty(value = "订单ID",required = false)
    private Long orderId;

    @ApiModelProperty(value = "采购订单号",required = false)
    private String orderNum;

    @ApiModelProperty(value = "订单对账ID",required = false)
    private Long reconciliationId;

    @ApiModelProperty(value = "付款申请ID",required = false)
    private Long paymentId;

    @ApiModelProperty(value = "申请单号",required = false)
    private String applyForNum;

    @ApiModelProperty(value = "申请时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date applyForDate;

    @ApiModelProperty(value = "更新时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date updateDate;

    @ApiModelProperty(value = "发票状态",required = false)
    private String state;

    @ApiModelProperty(value = "申请人编码",required = false)
    private String applicantCode;

    @ApiModelProperty(value = "申请人名称(供应商名称)",required = false)
    private String applicantName;

    @ApiModelProperty(value = "付款类型",required = false)
    private String paymentType;

    @ApiModelProperty(value = "对账单号",required = false)
    private String reconciliationNum;

    @ApiModelProperty(value = "合同名称",required = false)
    private String contractName;

    @ApiModelProperty(value = "合同编号XM",required = false)
    private String contractCode;

    @ApiModelProperty(value = "合同编号HB",required = false)
    private String goodsContractId;

    @ApiModelProperty(value = "项目id",required = false)
    private String projectId;

    @ApiModelProperty(value = "项目名称",required = false)
    private String projectName;

    @ApiModelProperty(value = "项目分期",required = false)
    private String projectStages;

    @ApiModelProperty(value = "总价",required = false)
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "累计收货金额",required = false)
    private BigDecimal totalGoodsPrice;

    @ApiModelProperty(value = "累计开票金额",required = false)
    private BigDecimal totalBillPrice;

    @ApiModelProperty(value = "发票类型",required = false)
    private String invoiceType;

    @ApiModelProperty(value = "合计发票金额",required = false)
    private BigDecimal totalInvoicePrice;

    @ApiModelProperty(value = "合计税额",required = false)
    private BigDecimal totalTaxAmount;

    @ApiModelProperty(value = "附件ID",required = false)
    private String attachment;

    @ApiModelProperty(value = "备注",required = false)
    private String remarks;

    @ApiModelProperty(value = "开票类型",required = false)
    private String applicationType;


    @ApiModelProperty(value = "附件",required = false)
    private List<Documentation> files;

    @ApiModelProperty(value = "发票明细",required = false)
    private List<IpInvoiceDetailDto> invoiceDetail;
    @ApiModelProperty(value = "商品明细",required = false)
    private List<IpInvoiceGoodsDto> invoiceGoods;

}
