package com.ekingwin.bas.cloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @ClassName: IpInvoiceGoodsDto
 * @Author: liujunfeng
 * @Date: 2019/11/22 10:12
 * @description:
 */
@Data
@ApiModel(value = "发票申请商品明细")
public class IpInvoiceGoodsDto {

    @ApiModelProperty(value = "id",required = false)
    private Long id;

    @ApiModelProperty(value = "发票ID",required = false)
    private Long invoiceId;

    @ApiModelProperty(value = "对账单ID",required = false)
    private Integer sorting;

    @ApiModelProperty(value = "商品名称",required = false)
    private String goodsName;

    @ApiModelProperty(value = "商品编码",required = false)
    private String goodsCode;

    @ApiModelProperty(value = "开票商品名称",required = false)
    private String billGoodsName;

    @ApiModelProperty(value = "开票规格型号",required = false)
    private String billSpecModel;

    @ApiModelProperty(value = "税收分类编码",required = false)
    private String taxTypeCode;

    @ApiModelProperty(value = "单位",required = false)
    private String unit;

    @ApiModelProperty(value = "税率",required = false)
    private String rate;

    @ApiModelProperty(value = "已收货数量",required = false)
    private String receivedGoodsNo;

    @ApiModelProperty(value = "已开票数量",required = false)
    private String receivedBillNo;

    @ApiModelProperty(value = "合同数量",required = false)
    private String contractNum;

    @ApiModelProperty(value = "本次开票数量",required = false)
    private String invoiceNo;

    @ApiModelProperty(value = "不含税金额",required = false)
    private BigDecimal noTaxAmountGoods;

    @ApiModelProperty(value = "税额",required = false)
    private BigDecimal rateGoods;

    @ApiModelProperty(value = "含税金额",required = false)
    private BigDecimal taxAmountGoods;

}
