package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @ClassName: IpInvoicePageDto
 * @Author: liujunfeng
 * @Date: 2019/11/22 10:47
 * @description:
 */
@Data
@ApiModel("获取发票记录列表")
public class IpInvoicePageDto extends BasePageDto{

    @ApiModelProperty(value = "id", required = false)
    private Long id;

    @ApiModelProperty(value = "查询条件", required = false)
    private String keyword;

    @ApiModelProperty(value = "发票号", required = false)
    private String invoiceNo;

    @ApiModelProperty(value = "合同名称", required = false)
    private String contractName;

    @ApiModelProperty(value = "合同编码xm")
    private String contractCode;

    @ApiModelProperty(value = "合同名称HB")
    private String goodsContractId;

    @ApiModelProperty(value = "发票合计金额", required = false)
    private String totalInvoicePrice;

    @ApiModelProperty(value = "创建时间开始", required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date applyForDateStart;

    @ApiModelProperty(value = "创建时间结束", required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date applyForDateEnd;

    @ApiModelProperty(value = "发票状态", required = false)
    private String states;

    @ApiModelProperty(value = "Y.查看、N.修改", required = false)
    private String conditions;

}
