package com.ekingwin.bas.cloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-05 10:16
 **/
@Data
@ApiModel("发货单")
public class IpOrderDeliverDto extends  BasDto {

    @ApiModelProperty(value = "发货单ID", required = false)
    private Long id;

    @ApiModelProperty(value = "收货人", required = false)
    private String consignee;

    @ApiModelProperty(value = "收货人工号", required = false)
    private String consigneeCode;

    @ApiModelProperty(value = "电话", required = false)
    private String phone;

    @ApiModelProperty(value = "收货地址", required = false)
    private String address;

    @ApiModelProperty(value = "物流公司", required = false)
    private String logisticsCompany;

    @ApiModelProperty(value = "物流单号", required = false)
    private String logisticsNum;

    @ApiModelProperty(value = "送货单号", required = false)
    private String deliverNum;

    @ApiModelProperty(value = "商品信息", required = false)
    private List<IpOrderDeliverGoodDto> goods;

    @ApiModelProperty(value = "收货人信息工号", required = false)
    private String receiverCodes;

    @ApiModelProperty(value = "收货人信息名称", required = false)
    private String receiverNames;

    @ApiModelProperty(value = "监理工号", required = false)
    private String supervisorCode;


    @ApiModelProperty(value = "项目负责人工号", required = false)
    private String projectLeaderCode;

    @ApiModelProperty(value = "物流公司编号")
    private String logisticsCompanyCode;

    @ApiModelProperty(value = "订单类型")
    private String orderType;
}
