package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-06 11:28
 **/
@Data
@ApiModel("物流信息")
public class IpOrderDeliverLogisticsDto extends BasDto {

    @ApiModelProperty(value = "送货单ID", required = false)
    private Long deliverId;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty(value = "处理日期（yyyy-MM-dd HH:mm:ss）",required = true)
    private Date handleTime;

    @ApiModelProperty(value = "处理信息", required = false)
    private String remark;

    @ApiModelProperty(value = "处理人", required = false)
    private String handleName;
}
