package com.ekingwin.bas.cloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-01 19:52
 **/
@Data
@ApiModel("订单商品草稿")
public class IpOrderGoodDraftsDto {

    @ApiModelProperty(value = "商品ID",required = false)
    private  Integer goodsid;

    @ApiModelProperty(value = "数量",required = false)
    private  String count;

    @ApiModelProperty(value = "价格",required = false)
    private String price;

    @ApiModelProperty(value = "不含税价格",required = false)
    private String bhsprice;

    @ApiModelProperty(value = "含税价格",required = false)
    private String hsprice;

    @ApiModelProperty(value = "税率",required = false)
    private String taxrate;

    @ApiModelProperty(value = "total",required = false)
    private String total;

    @ApiModelProperty(value = "货币币种",required = false)
    private  String currency;

    @ApiModelProperty(value = "图片" ,required = false)
    private  String urlId;

    @ApiModelProperty(value = "价格类型" ,required = false)
    private  String pricetype;


    @ApiModelProperty(value = "含税总价" ,required = false)
    private String goodstotalhsprice;

    @ApiModelProperty(value = "不含税总价" ,required = false)
    private String goodstotalbhsprice;

    @ApiModelProperty(value = "品牌" ,required = false)
    private  String brand;

    @ApiModelProperty(value = "商品名称" ,required = false)
    private  String goodsname;

    @ApiModelProperty(value = "商品编码" ,required = false)
    private  String goodsnum;

    @ApiModelProperty(value = "单位" ,required = false)
    private  String unit;

    @ApiModelProperty(value = "一级分类" ,required = false)
    private  String ftnpfirstcategorycode;
    private  String ftnpfirstcategoryname;

    @ApiModelProperty(value = "二级分类" ,required = false)
    private  String ftnpsecondcategorycode;
    private  String ftnpsecondcategoryname;

    @ApiModelProperty(value = "三级分类" ,required = false)
    private  String ftnpthreecategorycode;
    private  String ftnpthreecategoryname;

    @ApiModelProperty(value = "税收分类编码" ,required = false)
    private  String taxtypecode;
    @ApiModelProperty(value = "开票商品名称" ,required = false)
    private  String billgoodsname;
    @ApiModelProperty(value = "开票规格型号" ,required = false)
    private  String billtypecode;
    @ApiModelProperty(value = "材质" ,required = false)
    private  String material;
    @ApiModelProperty(value = "产地" ,required = false)
    private  String proaddr;
    @ApiModelProperty(value = "保修年限" ,required = false)
    private  String guarantee;

    @ApiModelProperty(value = "单位名称" ,required = false)
    private  String unitName;

    @ApiModelProperty(value = "授权商" ,required = false)
    private  String  supplierid;

    @ApiModelProperty(value = "授权商" ,required = false)
    private  String  supplier;

    @ApiModelProperty(value = "合同名称" ,required = false)
    private String contractName;

    @ApiModelProperty(value = "合同编码" ,required = false)
    private  String contractCode;

    @ApiModelProperty(value = "商票比例" ,required = false)
    private String proportion;

    @ApiModelProperty(value = "补偿利息" ,required = false)
    private  String compensation;

    @ApiModelProperty(value = "支付方式" ,required = false)
    private  String paymentMethod;

    @ApiModelProperty(value = "支付方式编码" ,required = false)
    private String paymentMethodCode;


    @ApiModelProperty(value = "运费" ,required = false)
    private  String freight;


    @ApiModelProperty(value = "商品运费" ,required = false)
    private  String goodsTotalFregin;

    @ApiModelProperty(value = "商票单价（含税）",required = false)
    private BigDecimal tickettaxprice;

    @ApiModelProperty(value = "商票单价（不含税）",required = false)
    private  BigDecimal ticketnotaxprice;

    @ApiModelProperty(value = "商票总价（含税）",required = false)
    private String ticketpricetotal;

    @ApiModelProperty(value = "商票总价（不含税）",required = false)
    private  String noticketpricetotal;

    @ApiModelProperty(value = "是否商票支付",required = false)
    private String isticket;

    @ApiModelProperty(value = "供货方式",required = false)
    private String supportType;

    @ApiModelProperty(value = "供货方式编码",required = false)
    private String supportCode;

    @ApiModelProperty(value = "供应商原价含税价格",required = false)
    private  String rmbhsprice;

    @ApiModelProperty(value = "供应商原价不含税价格",required = false)
    private  String rmbbhsprice;

    @ApiModelProperty(value ="商品类型 CG 常规 HD 活动 PM 拍卖")
    private String category;

    @ApiModelProperty(value = "结算公司")
    private String clearingcorp;

    @ApiModelProperty(value = "结算公司标识")
    private String clearingcorpcode;

    @ApiModelProperty(value = "物料颜色")
    private String speciColor;

    @ApiModelProperty(value = "型号")
    private String speciModel;

    @ApiModelProperty(value = "尺寸")
    private String speciSize;

    @ApiModelProperty(value = "其他")
    private String speciOther;

    @ApiModelProperty(value = "属性组合价格ID")
    private String attrid;

    @ApiModelProperty(value = "规格型号")
    private String ftnpspecificationsmodel;

    @ApiModelProperty(value = "原价含税)总价(实付)")
    private String goodsrmbtotalhsprice;

    @ApiModelProperty(value = "原价（不含税)总价(实付)")
    private String goodsrmbtotalbhsprice;
}
