package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: IpOrderReconciliationRecordDto
 * @Author: liujunfeng
 * @Date: 2019/11/28 17:33
 * @description:
 */
@Data
public class IpOrderReconciliationRecordPageDto extends BasePageDto{

    @ApiModelProperty(value = "id", required = false)
    private Long id;

    @ApiModelProperty(value = "订单类型", required = true)
    private String orderType;

    @ApiModelProperty(value = "是否已对账：1已确认 0 未确认", required = true)
    private String orderStatus;

    @ApiModelProperty(value = "账单号", required = false)
    private String billNumber;

    @ApiModelProperty(value = "生成日期开始", required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date createDateStart;

    @ApiModelProperty(value = "生成日期结束", required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date createDateEnd;

    @ApiModelProperty(value = "订单ID", required = false)
    private String orderId;

    @ApiModelProperty(value = "订单号", required = false)
    private String orderNum;

    @ApiModelProperty(value = "订单商品ID", required = false)
    private String orderGoodsId;

    @ApiModelProperty(value = "项目编号", required = false)
    private String projectCode;

    @ApiModelProperty(value = "项目名称", required = false)
    private String projectName;

    @ApiModelProperty(value = "分期编号", required = false)
    private String installmentCode;

    @ApiModelProperty(value = "分期名称", required = false ,hidden = true)
    private String installmentName;

    @ApiModelProperty(value = "合同编码", required = false)
    private String contractCode;

    @ApiModelProperty(value = "合同名称", required = false)
    private String contractName;

    @ApiModelProperty(value = "订单总额", required = false)
    private BigDecimal orderTotalPrice;

    @ApiModelProperty(value = "下单人", required = false)
    private String orderPersion;

    @ApiModelProperty(value = "下单人标识", required = false)
    private String orderPersionCode;

    @ApiModelProperty(value = "下单时间开始", required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date orderTimeStart;

    @ApiModelProperty(value = "下单时间结束", required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date orderTimeEnd;

    @ApiModelProperty(value = "订单状态", required = false)
    private String orderState;

    @ApiModelProperty(value = "商品编码", required = false)
    private String goodsId;

    @ApiModelProperty(value = "商品名称", required = false)
    private String goodsName;

    @ApiModelProperty(value = "开票商品名称", required = false)
    private String billGoodsName;

    @ApiModelProperty(value = "开票规格型号", required = false)
    private String billSpecifiModel;

    @ApiModelProperty(value = "价格类型", required = false)
    private String priceType;

    @ApiModelProperty(value = "税收分类编码", required = false)
    private String taxTypeCode;

    @ApiModelProperty(value = "品牌", required = false)
    private String brand;

    @ApiModelProperty(value = "商品一级分类编码", required = false)
    private String ftnpfirstcategorycode;

    @ApiModelProperty(value = "商品一级分类名称", required = false)
    private String ftnpfirstcategoryname;

    @ApiModelProperty(value = "商品二级分类编码", required = false)
    private String ftnpsecondcategorycode;

    @ApiModelProperty(value = "商品二级分类名称", required = false)
    private String ftnpsecondcategoryname;

    @ApiModelProperty(value = "商品三级分类编码", required = false)
    private String ftnpthreecategorycode;

    @ApiModelProperty(value = "商品三级分类名称", required = false)
    private String ftnpthreecategoryname;

    @ApiModelProperty(value = "税率", required = false)
    private String rate;

    @ApiModelProperty(value = "综合不含税单价", required = false)
    private BigDecimal notaxPrice;

    @ApiModelProperty(value = "综合含税单价", required = false)
    private BigDecimal price;

    @ApiModelProperty(value = "小计", required = false)
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "对账含税金额", required = false)
    private BigDecimal billTaxPrice;

    @ApiModelProperty(value = "发货方", required = false)
    private String shipper;

    @ApiModelProperty(value = "发货方Id", required = false)
    private String shipperId;

    @ApiModelProperty(value = "运费", required = false)
    private BigDecimal freight;

    @ApiModelProperty(value = "订单数量", required = false)
    private String orderQuantity;

    @ApiModelProperty(value = "已收货数量", required = false)
    private Integer receivingNum;

    @ApiModelProperty(value = "本次收货数量", required = false)
    private String theReceivingNum;

    @ApiModelProperty(value = "未收货数量", required = false)
    private Integer notReceivingNum;



}
