package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@Api("付款明细信息")
public class IpPaymentDetailDto {
    @ApiModelProperty(value = "id",required = false)
    private Long id;
    @ApiModelProperty(value = "对账单ID",required = false)
    private Long sorte;
    @ApiModelProperty(value = "商品名称",required = false)
    private String goodsName;
    @ApiModelProperty(value = "商品编码",required = false)
    private String goodsCode;
    @ApiModelProperty(value = "税率",required = false)
    private String rate;
    @ApiModelProperty(value = "已收货数量",required = false)
    private String receivedGoodsNo;
    @ApiModelProperty(value = "已对账数量",required = false)
    private String checkeAmount;
    @ApiModelProperty(value = "进度款未支付数量",required = false)
    private String unpaidQuantity;

    @ApiModelProperty(value = "合同数量",required = false)
    private String contractNum;
    @ApiModelProperty(value = "预付款未支付数量",required = false)
    private String contractQuantity;

    @ApiModelProperty(value = "本次申请数量",required = false)
    private String applyNum;
    @ApiModelProperty(value = "创建时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date createTime;
    @ApiModelProperty(value = "更新时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date updateTime;
    @ApiModelProperty(value = "付款单id",required = false)
    private Long paymentId;


    @ApiModelProperty(value = "单价（原价）",required = false)
    private BigDecimal price;
    @ApiModelProperty(value = "不含税单价（原价）",required = false)
    private BigDecimal priceNoTax;
    @ApiModelProperty(value = "税额（原价）",required = false)
    private BigDecimal rateGoods;
    @ApiModelProperty(value = "含税总金额（原价）",required = false)
    private BigDecimal taxAmountGoods;
    @ApiModelProperty(value = "不含税总金额（原价）",required = false)
    private BigDecimal noTaxAmountGoods;

    @ApiModelProperty(value = "单价（上浮价）",required = false)
    private BigDecimal salePrice;
    @ApiModelProperty(value = "不含税单价（上浮价）",required = false)
    private BigDecimal salePriceNoTax;
    @ApiModelProperty(value = "税额（上浮价）",required = false)
    private BigDecimal taxAmtf;
    @ApiModelProperty(value = "含税总金额（上浮价）",required = false)
    private BigDecimal amtSalePrice;
    @ApiModelProperty(value = "不含税总金额（上浮价）",required = false)
    private BigDecimal amtSalePriceNoTax;

}
