package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@ApiModel("付款单信息")
public class IpPaymentDto extends  BasDto {

    @ApiModelProperty(value = "id",required = false)
    private Long id;
    @ApiModelProperty(value = "订单id",required = false)
    private Long orderId;
    @ApiModelProperty(value = "采购订单号",required = false)
    private String orderNum;
    @ApiModelProperty(value = "订单对账id",required = false)
    private String reconciliationId;
    @ApiModelProperty(value = "状态",required = false)
    private String state;

    @ApiModelProperty(value = "申请单号",required = false)
    private String applyForNum;
    @ApiModelProperty(value = "申请时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date applyDate;
    @ApiModelProperty(value = "申请人编码",required = false)
    private String applicantCode;
    @ApiModelProperty(value = "申请人名称",required = false)
    private String applicantName;
    @ApiModelProperty(value = "付款类型",required = false)
    private String paymentType;
    @ApiModelProperty(value = "对账单号",required = false)
    private String reconciliationNum;
    @ApiModelProperty(value = "合同名称",required = false)
    private String contractName;

    @ApiModelProperty(value = "合同编码XM",required = false)
    private String contractCode;

    @ApiModelProperty(value = "合同编码HB",required = false)
    private String goodsContractId;

    @ApiModelProperty(value = "项目id",required = false)
    private String projectId;
    @ApiModelProperty(value = "项目名称",required = false)
    private String projectName;
    @ApiModelProperty(value = "项目分期",required = false)
    private String projectStages;
    @ApiModelProperty(value = "付款申请类型",required = false)
    private String applicationType;
    @ApiModelProperty(value = "计划收款月份",required = false)
    @JsonFormat(pattern = "yyyy-MM",timezone = "GMT+8")
    private Date planMonth;
    @ApiModelProperty(value = "收款单位（供应商名字）",required = false)
    private String supplierName;
    @ApiModelProperty(value = "收款单位ID",required = false)
    private String supplierId;
    @ApiModelProperty(value = "银行账号",required = false)
    private String bankNum;
    @ApiModelProperty(value = "卡号行",required = false)
    private String openBank;
    @ApiModelProperty(value = "合同金额",required = false)
    private BigDecimal contractAmount;
    @ApiModelProperty(value = "最新总价",required = false)
    private BigDecimal totalPrice;
    @ApiModelProperty(value = "申请金额",required = false)
    private BigDecimal applyAmount;
    @ApiModelProperty(value = "累计应付金额",required = false)
    private BigDecimal accumulatedAmount;
    @ApiModelProperty(value = "累计已付金额",required = false)
    private BigDecimal paidAmount;
    @ApiModelProperty(value = "备注",required = false)
    private String remark;
    @ApiModelProperty(value = "附件",required = false)
    private String attachment;

    @ApiModelProperty(value = "付款明细",required = false)
    private List<IpPaymentDetailDto> payment;
    @ApiModelProperty(value = "附件",required = false)
    private List<Documentation> files;

    @ApiModelProperty(value = "付款申请金额上浮价",required = false)
    private BigDecimal paymentSalePrice;


    @ApiModelProperty(value = "审定金额",required = false)
    private String authorizedAmount;
    @ApiModelProperty(value = "更新时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date updateTime;
    @ApiModelProperty(value = "创建时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date createTime;
    @ApiModelProperty(value = "创建人",required = false)
    private String createUser;
    @ApiModelProperty(value = "创建人工号",required = false)
    private String createId ;

}