package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel("获取付款申请列表")
    public class IpPaymentPageDto extends BasePageDto {

    @ApiModelProperty(value = "id", required = false)
    private Long id;

    @ApiModelProperty(value = "申请单号",required = false)
    private String applyForNum;

    @ApiModelProperty(value = "申请金额",required = false)
    private BigDecimal applyAmount;

    @ApiModelProperty(value = "申请开始时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date applyDateStart;

    @ApiModelProperty(value = "申请结束时间",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date applyDateEnd;

    @ApiModelProperty(value = "审定金额",required = false)
    private String authorizedAmount;

    @ApiModelProperty(value = "合同名称",required = false)
    private String contractName;

    @ApiModelProperty(value = "合同编码",required = false)
    private String contractCode;

    @ApiModelProperty(value = "合同编码HB",required = false)
    private String goodsContractId;

    @ApiModelProperty(value = "合同金额",required = false)
    private BigDecimal contractAmount;

    @ApiModelProperty(value = "累计已付金额",required = false)
    private BigDecimal paidAmount;

    @ApiModelProperty(value = "状态",required = false)
    private String state;

    @ApiModelProperty(value = "查询条件", required = false)
    private String keyword;

    @ApiModelProperty(value = "Y.查看、N.修改", required = false)
    private String conditions;
}
