package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel("查看付款明细")
public class IpPaymentPayInfoDto extends BasePageDto {

    @ApiModelProperty(value = "id",required = false)
    private Long id;

    @ApiModelProperty(value = "SAP付款单号",required = false)
    private String payid;

    @ApiModelProperty(value = "申请单号",required = true)
    private String applyForNum;

    @ApiModelProperty(value = "付款批次",required = false)
    private String paymentItem;

    @ApiModelProperty(value = "本批次付款金额")
    private BigDecimal paymentPrice;

    @ApiModelProperty(value = "累计已付金额")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "确认支付日期",required = false)
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date confirmDate;

    @ApiModelProperty(value = "查询条件",required = false)
    private String keyword;

    @ApiModelProperty(value = "订单类型", required = true)
    private String orderType;

    @ApiModelProperty(value = "是否已对账：1已确认 0 未确认", required = true)
    private String orderStatus;

    @ApiModelProperty(value = "是否付款申请 ",required = false)
    private String isPayment;

    @ApiModelProperty(value = "是否发票申请",required = false)
    private String isInvoice;

}