package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-28 18:25
 **/
@Data
@ApiModel("代下单")
public class ProIpOrdersDto {


    @ApiModelProperty(value = "主题", required = false)
    private String theme;
    @ApiModelProperty(value = "申请工号", required = false)
    private String applicationnumber;
    @ApiModelProperty(value = "申请人", required = false)
    private String applicant;
    @ApiModelProperty(value = "申请时间", required = false)
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date applicationtime;
    @ApiModelProperty(value = "合同名称", required = false)
    private String contractname;
    @ApiModelProperty(value = "供应商名称", required = false)
    private String suppliername;
    @ApiModelProperty(value = "备注", required = false)
    private String remarks;
    @ApiModelProperty(value = "附件路径", required = false)
    private String enclosure;
    @ApiModelProperty(value = "备用字段", required = false)
    private String standbyfield;
    @ApiModelProperty(value = "流程id,不需要传递，流程发起成功后返回值", required = false)
    private String instanceid;
    @ApiModelProperty(value = "合同编码", required = false)
    private String contractnamecode;
    @ApiModelProperty(value = "供应商编号", required = true)
    private String suppliercode;

}
