package com.ekingwin.bas.cloud.dto.sapmessage;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName: SapPaymentReturnDto
 * @Author: liujunfeng
 * @Date: 2019/12/12 20:26
 * @description:
 */
@Data
public class SapPaymentReturnDto {


    @ApiModelProperty(value = "电商付款申请单号",required = false)
    private String paymentno;

    @ApiModelProperty(value = "付款申请单号",required = false)
    private String paymentnos;

    @ApiModelProperty(value = "付款申请状态",required = false)
    private String paymentstatus;

    @ApiModelProperty(value = "付款申请状态描述",required = false)
    private String paymentstatusname;

    @ApiModelProperty(value = "付款申请金额（原价）",required = false)
    private BigDecimal paymentprice;

    @ApiModelProperty(value = "付款申请金额（上浮价）",required = false)
    private BigDecimal paymentsaleprice;

    @ApiModelProperty(value = "付款单编号",required = false)
    private String paynocode;

    @ApiModelProperty(value = "发票类型",required = false)
    private String nvoicetype;

    @ApiModelProperty(value = "发票状态",required = false)
    private String invoicestatus;

    @ApiModelProperty(value = "审定金额",required = false)
    private BigDecimal revaamt;

    @ApiModelProperty(value = "已付金额",required = false)
    private BigDecimal amtyet;

    @ApiModelProperty(value = "关联项目公司付款申请",required = false)
    private String payanoproj;

    @ApiModelProperty(value = "付款申请单行项目信息",required = false)
    private List<PaymentPayAppItemInfoDto> payAppItemInfo;

    @ApiModelProperty(value = "付款申请单发票信息",required = false)
    private List<PaymentInfosDto> invInfos;

}
