package com.ekingwin.bas.cloud.dto.tick;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import java.math.BigDecimal;

/**
 * @ClassName: SettlementDetails
 * @Author: liujunfeng
 * @Date: 2019/10/22 15:16
 * @description:
 */
@Data
@ApiModel("发票商品信息")
@XmlAccessorType(XmlAccessType.FIELD)
public class SettlementDetailsReq {

    @ApiModelProperty(value = "结算单明细号", required = true)
    private String settlementItemNo;

    @ApiModelProperty(value = "货物或应税劳务代码 （忽略）", required = false)
    private String itemCode;

    @ApiModelProperty(value = "货物或应税劳务名称--开票商品名称", required = true)
    private String itemName;

    @ApiModelProperty(value = "型号规格--开票规格型号", required = false)
    private String itemSpec;

    @ApiModelProperty(value = "数量单位--单位", required = false)
    private String quantityUnit;

    @ApiModelProperty(value = "数量--数量", required = true)
    private BigDecimal quantity;

    @ApiModelProperty(value = "价格方式(0-不含税价1-含税价)", required = true)
    private String priceMethod;

    @ApiModelProperty(value = "税率", required = true)
    private BigDecimal taxRate;

    @ApiModelProperty(value = "单价（不含税单价）", required = true)
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "不含税金额（小计）", required = true)
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额", required = true)
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "含税金额（含税小计）", required = true)
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "不含税折扣金额", required = false)
    private BigDecimal discountWithoutTax;

    @ApiModelProperty(value = "折扣税额", required = false)
    private BigDecimal discountTax;

    @ApiModelProperty(value = "含税折扣金额", required = false)
    private BigDecimal discountWithTax;

    @ApiModelProperty(value = "税收分类编码版本号", required = true)
    private String goodsNoVer="19";

    @ApiModelProperty(value = "税收分类编码", required = true)
    private String goodsTaxNo;

    @ApiModelProperty(value = "税收分类编码匹配码(商品开票名称)", required = true)
    private String taxConvertCode;

    @ApiModelProperty(value = "是否享受税收优惠政策(忽略)", required = false)
    private String taxPre;

    @ApiModelProperty(value = "享受税收优惠政策内容(忽略)", required = false)
    private String taxPreCon;

    @ApiModelProperty(value = "零税率标志(忽略)", required = false)
    private String zeroTax;

    @ApiModelProperty(value = "扣除额(忽略)", required = false)
    private String taxDedunction;

    @ApiModelProperty(value = "结算方式（中文）(忽略)", required = false)
    private String settlementMethod;

    @ApiModelProperty(value = "会计结算期间(忽略)", required = false)
    private String acctPeriod;

    @ApiModelProperty(value = "合同号(忽略)", required = false)
    private String contractNo;

    @ApiModelProperty(value = "订单号", required = false)
    private String orderNo;

    @ApiModelProperty(value = "合同行号(忽略)", required = false)
    private String contractDetailNo;

    @ApiModelProperty(value = "订单行号(忽略)", required = false)
    private String orderDetailNo;

    @ApiModelProperty(value = "项目大类（中文）(忽略)", required = false)
    private String commFmlyDesc;

    @ApiModelProperty(value = "项目中类（中文）(忽略)", required = false)
    private String commDesc;

    @ApiModelProperty(value = "项目细类（中文）(忽略)", required = false)
    private String categoryDesc;

    @ApiModelProperty(value = "其他特殊说明(忽略)", required = false)
    private String extRemark;

}
