package com.ekingwin.bas.cloud.dto.tick;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import java.math.BigDecimal;

/**
 * @ClassName: Settlement
 * @Author: liujunfeng
 * @Date: 2019/10/22 14:22
 * @description:
 */
@Data
@ApiModel("发票主信息")
@XmlAccessorType(XmlAccessType.FIELD)
public class SettlementMainReq {

    @ApiModelProperty(value = "采购订单号", required = true)
    private String ordernum;

    @ApiModelProperty(value = "收货单编号", required = true)
    private String receiverNum;


    @ApiModelProperty(value = "结算单号", required = false)
    private String settlementNo;

    @ApiModelProperty(value = "操作类型(0-作废1-上传9-删除)", required = true)
    private String status;

    @ApiModelProperty(value = "业务单据类型(AP-进项结算单AR-销项结算单)", required = true)
    public String businessBillType="AR";

    @ApiModelProperty(value = "发票类型(c-增值税普通发票s-增值税专用发票ce-增值税电子普通发票)", required = true)
    private String invoiceType;

    @ApiModelProperty(value = "集团标志(融创设置值为：RCJT)", required = true)
    private String tenantCode="RCJT";

    @ApiModelProperty(value = "销方信息识别方式(0-按销方编号识别1-按销方税号、名称识别)", required = true)
    private String sellerInfoFill="1";

    @ApiModelProperty(value = "销方编号", required = true)
    private String sellerNo;

    @ApiModelProperty(value = "销方税号", required = true)
    private String sellerTaxNo;

    @ApiModelProperty(value = "销方名称", required = true)
    private String sellerName;

    @ApiModelProperty(value = "销方地址", required = true)
    private String sellerAddress;

    @ApiModelProperty(value = "销方电话", required = true)
    private String sellerTel;

    @ApiModelProperty(value = "销方银行名称", required = true)
    private String sellerBankName;

    @ApiModelProperty(value = "销方银行账号", required = true)
    private String sellerBankAccount;

    @ApiModelProperty(value = "购方信息识别方式", required = true)
    private String purchaserInfoFill="1";

    @ApiModelProperty(value = "购方编号", required = true)
    private String purchaserNo;

    @ApiModelProperty(value = "购方税号", required = true)
    private String purchaserTaxNo;

    @ApiModelProperty(value = "购方名称", required = true)
    private String purchaserName;

    @ApiModelProperty(value = "购方地址", required = false)
    private String purchaserAddress;

    @ApiModelProperty(value = "购方电话", required = false)
    private String purchaserTel;

    @ApiModelProperty(value = "购方银行名称", required = false)
    private String purchaserBankName;

    @ApiModelProperty(value = "购方银行账号", required = false)
    private String purchaserBankAccount;

    @ApiModelProperty(value = "不含税金额", required = true)
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额", required = true)
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "含税金额", required = true)
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "备注", required = false)
    private String remark;

    @ApiModelProperty(value = "收款人姓名", required = true)
    private String cashierName;

    @ApiModelProperty(value = "复核人姓名", required = true)
    private String checkerName;

    @ApiModelProperty(value = "开票人姓名", required = true)
    private String invoicerName;

    @ApiModelProperty(value = "原发票号码", required = false)
    private String originInvoiceNo;

    @ApiModelProperty(value = "原发票代码", required = false)
    private String originInvoiceCode;

    @ApiModelProperty(value = "红字信息表编号", required = false)
    private String redNotificationNo;

    @ApiModelProperty(value = "期望开票日期", required = false)
    private String predictInvoiceDate;

    @ApiModelProperty(value = "开票结算期间", required = false)
    private String settlementPeriod;

    @ApiModelProperty(value = "自定义单据分类", required = false)
    private String customeBillType;

    @ApiModelProperty(value = "邮箱", required = false)
    private String reciveUser;


    @ApiModelProperty(value = "结算公司")
    private String clearingcorpcode;


}
