package com.ekingwin.bas.cloud.dto.tick;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import java.util.List;

/**
 * @ClassName: Settlement
 * @Author: liujunfeng
 * @Date: 2019/10/22 20:52
 * @description:
 */
@Data
@ApiModel("开票信息")
@XmlAccessorType(XmlAccessType.FIELD)
public class SettlementReq {

    @ApiModelProperty(value = "采购订单号", required = true)
    private String ordernum;

    @ApiModelProperty(value = "收货单编号", required = true)
    private String receiverNum;

    @ApiModelProperty(value = "收款公司标识", required = true)
    private String contactid;


    @ApiModelProperty(value = "发票主信息", required = true)
    private SettlementMainReq settlementMain;

    @ApiModelProperty(value = "发票商品信息", required = true)
    private List<SettlementDetailsReq> settlementDetails;

}
