package com.ekingwin.bas.cloud.monitor.dao;


import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationConfirmDto;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationDto;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationPageDto;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationSearchDto;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationAllExcelVo;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationExcelVo;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationTotalVo;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.List;

@Repository
public interface IpOrderReconciliationDtoMapper {


    /**
     * 批量插入
     * @param list
     * @return
     */
    int insertBetch(@Param(value = "list")List<IpOrderReconciliationDto> list);


    /**
     *
     * @param searchDto
     * @return
     */
    List<IpOrderReconciliationVo> getOrderReconciliation(IpOrderReconciliationSearchDto searchDto);

    /**
     *  明细汇总
     * @param searchDto
     * @return
     */
    List<IpOrderReconciliationVo>  getAllOrderReconciliation(IpOrderReconciliationSearchDto searchDto);

    /**
     *
     * @param confirmDto
     * @return
     */
    List<IpOrderReconciliationVo> getConfirmOrder(IpOrderReconciliationConfirmDto confirmDto);


    /**
     * 修改未对账改为已对账
     * @param confirmDto
     * @return
     */
    int updateStatus(IpOrderReconciliationConfirmDto confirmDto);

    //文件导出
    List<IpOrderReconciliationExcelVo> getExcel(IpOrderReconciliationSearchDto  orderReconciliationSearchDto)throws Exception;

    //列表字段模糊查询
    List<IpOrderReconciliationVo> getOrderWatitingPageDetail(IpOrderReconciliationPageDto ipOrderReconciliationPageDto);


    /**
     * 获取汇总数据
     * @param ipOrderReconciliationSearchDto
     * @return
     */
    IpOrderReconciliationTotalVo getOrderTotal(IpOrderReconciliationSearchDto ipOrderReconciliationSearchDto);


    /**
     * 获取退货信息
     * @param ipOrderReconciliationSearchDto
     * @return
     */
     BigDecimal getOrderRejectTotal(IpOrderReconciliationSearchDto ipOrderReconciliationSearchDto);


    /**
     * 导出明细汇总
     * @param searchDto
     * @return
     */
     List<IpOrderReconciliationAllExcelVo> getAllExcel(IpOrderReconciliationSearchDto searchDto);
}