package com.ekingwin.bas.cloud.monitor.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@Data
@Api(value = "字段列表查询")
@Table(name = "ip_order_reconciliation_check")
public class IpOrderReconciliationCheckDto  {

    private Long id;

    @ApiModelProperty(value = "订单ID")
    private String orderId;

    @ApiModelProperty(value = "订单号")
    private String orderNum;

    @ApiModelProperty(value = "商品名称")
    private String goodsName;

    @ApiModelProperty(value = "商品ID")
    private String goodsId;

    @ApiModelProperty(value = "下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date orderTime;

    @ApiModelProperty(value = "下单人")
    private String orderPersion;

    @ApiModelProperty(value = "下单人工号")
    private String orderPersionCode;

    @ApiModelProperty(value = "下单数量")
    private String orderAccount;

    @ApiModelProperty(value = "下单价格")
    private BigDecimal orderPrice;

    @ApiModelProperty(value = "税率")
    private String rate;

    @ApiModelProperty(value = "综合含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "综合不含税单价")
    private BigDecimal notaxPrice;

    @ApiModelProperty(value = "小计")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "订单总额")
    private BigDecimal orderTotalPrice;

    @ApiModelProperty(value = "已收货数量")
    private String receiverNum;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "供应商编码")
    private String supplierNum;

    @ApiModelProperty(value = "供应商Id")
    private String supplierId;

    @ApiModelProperty(value = "供应商含税单价")
    private BigDecimal supplierPrice;

    @ApiModelProperty(value = "供应商不含税单价")
    private BigDecimal supplierNotaxprice;

    @ApiModelProperty(value = "供应商小计")
    private BigDecimal supplierTotalPrice;

    @ApiModelProperty(value = "利润额")
    private BigDecimal profitMargin;

    @ApiModelProperty(value = "账单号")
    private String billId;

    private String order_type;


}