package com.ekingwin.bas.cloud.monitor.dto;

import com.ekingwin.bas.cloud.dto.BasePageDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "列表字段模糊查询")
public class IpOrderReconciliationPageDto extends BasePageDto {

    @ApiModelProperty(value = "订单ID")
    private String orderId;

    @ApiModelProperty(value = "订单商品ID")
    private String orderGoodsId;

    @ApiModelProperty(value = "订单号")
    private String orderNum;

    @ApiModelProperty(value = "商品名称")
    private String goodsName;

    @ApiModelProperty(value = "商品ID")
    private String goodsId;

    @ApiModelProperty(value = "下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date orderTime;

    @ApiModelProperty(value = "下单人")
    private String orderPersion;

    @ApiModelProperty(value = "下单人标识")
    private String orderPersionCode;

    @ApiModelProperty(value = "下单数量")
    private String orderAccount;

    @ApiModelProperty(value = "下单价格")
    private BigDecimal orderPrice;

    @ApiModelProperty(value = "税率")
    private String rate;

    @ApiModelProperty(value = "综合含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "综合不含税单价")
    private BigDecimal notaxPrice;

    @ApiModelProperty(value = "小计")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "订单总额")
    private BigDecimal orderTotalPrice;

    @ApiModelProperty(value = "已收货数量")
    private String receiverNum;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "供应商编码")
    private String supplierNum;

    @ApiModelProperty(value = "供应商Id")
    private String supplierId;

    @ApiModelProperty(value = "供应商含税单价")
    private BigDecimal supplierPrice;

    @ApiModelProperty(value = "供应商不含税单价")
    private BigDecimal supplierNotaxprice;

    @ApiModelProperty(value = "供应商小计")
    private BigDecimal supplierTotalPrice;

    @ApiModelProperty(value = "利润额")
    private BigDecimal profitMargin;

    private String orderType;

    @ApiModelProperty(value = "本次收货数量")
    private String account;

    @ApiModelProperty(value = "关键字")
    private String keyword;
}
