package com.ekingwin.bas.cloud.monitor.rabbit.receiver;


import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationDto;
import com.ekingwin.bas.cloud.monitor.service.WaitingReconciliationService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RabbitListener(bindings = @QueueBinding(
        value = @Queue(value = "${rabbitmq.moitor.receiver.monitororder}", autoDelete = "true"),
        exchange = @Exchange(value = "${rabbitmq.moitor.exchange.monitororder}", type = ExchangeTypes.TOPIC),
        key = "order.monitororder.info"
))
public class ReconciliationOrderReceiver {

    private Logger logger = LoggerFactory.getLogger(ReconciliationOrderReceiver.class);

    @Autowired
    private WaitingReconciliationService waitingReconciliationService;


    @RabbitHandler
    public void saveOrder(String msg) throws Exception{
        logger.info(msg+"22222222222");
        JSONArray jsonArray = JSONArray.fromObject(msg);
        if (jsonArray !=null && jsonArray.size()>0){
            List<IpOrderReconciliationDto> orderPaymentResultDtos=new ArrayList<>();
            for (Object object : jsonArray) {
                JSONObject jsonObject1=(JSONObject)object;
                IpOrderReconciliationDto orderReconciliationDto = (IpOrderReconciliationDto)JSONObject.toBean(jsonObject1, IpOrderReconciliationDto.class);
                orderPaymentResultDtos.add(orderReconciliationDto);
            }
            waitingReconciliationService.saveWaitingOrder(orderPaymentResultDtos);
        }
    }



}
