package com.ekingwin.bas.cloud.monitor.rabbit.sender;

import com.ekingwin.bas.cloud.monitor.config.RabbitMonitorExchangeConfig;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationConfirmOrderSender {
    @Autowired
    private AmqpTemplate rabbitTemplate;

    @Autowired
    private RabbitMonitorExchangeConfig rabbitExchange;


    /**
     *
     * @Param:
     *
     * @param sendConfig
     *@param jsonStr 参数
     * @return: void
     * @Author: zhangjie
     * @Date: 2019/10/24 17:13
     */
    public void send(String sendConfig,String jsonStr)
            throws InterruptedException {
        try {
            String  exchange=rabbitExchange.getConfirmmonitororder();
            rabbitTemplate.convertAndSend(exchange,sendConfig,jsonStr);
        }catch (Exception e){
            e.printStackTrace();
        }

    }
}
