package com.ekingwin.bas.cloud.monitor.service;

import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationConfirmDto;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationDto;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationSearchDto;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationTotalVo;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationVo;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface WaitingReconciliationService {


    void saveWaitingOrder(List<IpOrderReconciliationDto> ipOrderReconciliationDto) throws Exception;


    /**
     * 查询所有订单列表
     * @param searchDto
     * @return
     */
    PageInfo<IpOrderReconciliationVo> getPageInfo(IpOrderReconciliationSearchDto searchDto);


    /**
     * 获取对账明细
     * @param searchDto
     * @return
     */
    PageInfo<IpOrderReconciliationVo> getAllOrderReconciliation(IpOrderReconciliationSearchDto searchDto);
    /**
     * 对账确认
     * @param confirmDto
     * @throws Exception
     */
    void  confirmOrderWaiting(IpOrderReconciliationConfirmDto confirmDto) throws Exception;

    //文件导出表格
    void getExcel(HttpServletResponse response, IpOrderReconciliationSearchDto  orderReconciliationSearchDto)throws Exception;


    /**
     * 获取统计数据
     * @param orderReconciliationSearchDto
     * @return
     */
    IpOrderReconciliationTotalVo getOrderTotal(IpOrderReconciliationSearchDto  orderReconciliationSearchDto);


    /**
     * 订单交易明细汇总
     * @param orderReconciliationSearchDto
     * @return
     */
    IpOrderReconciliationTotalVo getOrderAllTotal(IpOrderReconciliationSearchDto  orderReconciliationSearchDto);


    /**
     * 订单明细汇总导出
     * @param response
     * @param orderReconciliationSearchDto
     * @throws Exception
     */
    void getAllExcel(HttpServletResponse response, IpOrderReconciliationSearchDto  orderReconciliationSearchDto)throws Exception;
}
