package com.ekingwin.bas.cloud.monitor.service.impl;

import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.monitor.dao.IpOrderReconciliationCheckDtoMapper;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationCheckPageDto;
import com.ekingwin.bas.cloud.monitor.service.IpOrderReconciliationCheckService;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationCheckExcelVo;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationCheckVo;
import com.ekingwin.bas.cloud.util.ExportExcelUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;

@Service
@Primary
public class IpOrderReconciliationCheckServiceImpl extends BaseService implements IpOrderReconciliationCheckService {

    @Autowired
    private IpOrderReconciliationCheckDtoMapper ipOrderReconciliationCheckDtoMapper;

    //查询字段列表
    @Override
    public PageInfo<IpOrderReconciliationCheckVo> getCheckList(IpOrderReconciliationCheckPageDto ipOrderReconciliationCheckPageDto) throws Exception {
        PageHelper.startPage(ipOrderReconciliationCheckPageDto.getPagenum(), ipOrderReconciliationCheckPageDto.getPagesize());
        List<IpOrderReconciliationCheckVo> checkList = ipOrderReconciliationCheckDtoMapper.getCheckList(ipOrderReconciliationCheckPageDto);
        return new PageInfo<>(checkList);
    }

    //表格导出
    @Override
    public void getCheckExcel(HttpServletResponse response, IpOrderReconciliationCheckExcelVo ipOrderReconciliationCheckExcelVo) throws Exception {
        ExportExcelUtil<IpOrderReconciliationCheckExcelVo> util = new ExportExcelUtil<>();
        List<IpOrderReconciliationCheckExcelVo> check = ipOrderReconciliationCheckDtoMapper.getCheckExcel(ipOrderReconciliationCheckExcelVo);
        String fileName = String.valueOf(System.currentTimeMillis()).substring(4, 13) + ".xlsx";
        String encode = URLEncoder.encode(fileName, "UTF-8");
        String headStr = "attachment; filename=\"" + encode + "\"";
        response.setContentType("APPLICATION/OCTET-STREAM");//转八进制
        response.setHeader("Content-Disposition", headStr);
        response.addHeader("Content-type", "application-download");
        OutputStream outputStream = response.getOutputStream();//得到输出流
        String[] checkExcel={
                "订单号","商品名称","商品ID","下单时间","下单人","下单数量","下单价格","税率","综合含税单价","综合不含税单价","小计","订单总额",
                "已收货数量","供应商名称","供应商编码","供应商含税单价","供应商不含税单价","供应商小计","利润额","账单号"
        };
        util.exportExcel("已对账清单",checkExcel,check,outputStream,ExportExcelUtil.EXCEl_FILE_2007);
        outputStream.flush();
        outputStream.close();
    }
}