package com.ekingwin.bas.cloud.monitor.service.impl;

import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.monitor.dao.IpOrderReconciliationDtoMapper;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationConfirmDto;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationDto;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationSearchDto;
import com.ekingwin.bas.cloud.monitor.rabbit.sender.ReconciliationConfirmOrderSender;
import com.ekingwin.bas.cloud.monitor.service.WaitingReconciliationService;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationAllExcelVo;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationExcelVo;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationTotalVo;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationVo;
import com.ekingwin.bas.cloud.util.ExportExcelUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Primary
public class WaitingReconciliationServiceImpl extends BaseService implements WaitingReconciliationService {

    @Autowired
    private IpOrderReconciliationDtoMapper ipOrderReconciliationDtoMapper;

    @Autowired
    private ReconciliationConfirmOrderSender reconciliationConfirmOrderSender;


    /**
     * 保存订单数据
     * @param ipOrderReconciliationDto
     * @throws Exception
     */
    @Override
    public void saveWaitingOrder(List<IpOrderReconciliationDto> ipOrderReconciliationDto) throws Exception{

        ipOrderReconciliationDtoMapper.insertBetch(ipOrderReconciliationDto);
    }

    /**
     * 获取对账列表
     * @param searchDto
     * @return
     */
    @Override
    public PageInfo<IpOrderReconciliationVo> getPageInfo(IpOrderReconciliationSearchDto searchDto){
        PageHelper.startPage(searchDto.getPagenum(),searchDto.getPagesize());
        List<IpOrderReconciliationVo> orderReconciliation = ipOrderReconciliationDtoMapper.getOrderReconciliation(searchDto);
        PageInfo<IpOrderReconciliationVo> ipOrderReconciliationVoPageInfo = new PageInfo<>(orderReconciliation);
        return  ipOrderReconciliationVoPageInfo;

    }

    /**
     * 获取对账明细
     * @param searchDto
     * @return
     */
    @Override
    public PageInfo<IpOrderReconciliationVo> getAllOrderReconciliation(IpOrderReconciliationSearchDto searchDto){
        PageHelper.startPage(searchDto.getPagenum(),searchDto.getPagesize());
        List<IpOrderReconciliationVo> orderReconciliation = ipOrderReconciliationDtoMapper.getAllOrderReconciliation(searchDto);
        PageInfo<IpOrderReconciliationVo> ipOrderReconciliationVoPageInfo = new PageInfo<>(orderReconciliation);
        return  ipOrderReconciliationVoPageInfo;

    }
    /**
     * 确认订单
     * @param confirmDto
     */
    @Override
    public void  confirmOrderWaiting(IpOrderReconciliationConfirmDto confirmDto) throws Exception{

        List<IpOrderReconciliationVo> confirmOrder = ipOrderReconciliationDtoMapper.getConfirmOrder(confirmDto);

        //修改状态为已确认对账
        ipOrderReconciliationDtoMapper.updateStatus(confirmDto);
        Map<String,List<IpOrderReconciliationVo>> orderWaiting=new HashMap<String,List<IpOrderReconciliationVo>>();
        if (confirmOrder !=null && confirmOrder.size()>0){
            for (IpOrderReconciliationVo ipOrderReconciliationVo : confirmOrder) {
                String supplierId = ipOrderReconciliationVo.getSupplierId();
                List<IpOrderReconciliationVo> ipOrderReconciliationVos = orderWaiting.get(supplierId);
                if (ipOrderReconciliationVos==null || ipOrderReconciliationVos.size()==0){
                    ipOrderReconciliationVos=new ArrayList<IpOrderReconciliationVo>();
                }
                ipOrderReconciliationVos.add(ipOrderReconciliationVo);
                orderWaiting.put(supplierId,ipOrderReconciliationVos);

            }
        }
        if (confirmOrder !=null && confirmOrder.size()>0){
            String string = JSONObject.fromObject(orderWaiting).toString();
            reconciliationConfirmOrderSender.send("confirm.confirmmonitororder.info",string);
        }

    }



    @Override
    public IpOrderReconciliationTotalVo getOrderTotal(IpOrderReconciliationSearchDto  orderReconciliationSearchDto){
        IpOrderReconciliationTotalVo orderTotal = ipOrderReconciliationDtoMapper.getOrderTotal(orderReconciliationSearchDto);
        if (orderTotal==null){
            orderTotal=new IpOrderReconciliationTotalVo();
        }
        return orderTotal;
    }


    /**
     *
     *  订单交易明细汇总
     * @param orderReconciliationSearchDto
     * @return
     */
    @Override
    public IpOrderReconciliationTotalVo getOrderAllTotal(IpOrderReconciliationSearchDto  orderReconciliationSearchDto){
        IpOrderReconciliationTotalVo orderTotal = ipOrderReconciliationDtoMapper.getOrderTotal(orderReconciliationSearchDto);
        if (orderTotal==null){
            orderTotal=new IpOrderReconciliationTotalVo();
        }
        //获取交易明细汇总 退货额
        BigDecimal orderRejectTotal = ipOrderReconciliationDtoMapper.getOrderRejectTotal(orderReconciliationSearchDto);
        if (orderRejectTotal==null){
            orderRejectTotal=new BigDecimal("0.00");
        }
        orderTotal.setRejectTotal(orderRejectTotal);
        return orderTotal;
    }



    //文件导出
    @Override
    public void getExcel(HttpServletResponse response, IpOrderReconciliationSearchDto  orderReconciliationSearchDto)throws Exception {
        ExportExcelUtil<IpOrderReconciliationExcelVo> util = new ExportExcelUtil<>();
        List<IpOrderReconciliationExcelVo> excel = ipOrderReconciliationDtoMapper.getExcel(orderReconciliationSearchDto);
        String fileName = String.valueOf(System.currentTimeMillis()).substring(4, 13) + ".xlsx";
        String encode = URLEncoder.encode(fileName, "UTF-8");
        String headStr="attachment;filename=\"" + encode + "\"";
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition", headStr);
        response.addHeader("Content-type", "application-download");
        ServletOutputStream outStream = response.getOutputStream();
        String[] orderReconCloumn={
                "订单号","商品名称","商品编码","下单时间","下单方","订单数量","下单价格","税率","综合不含税单价","综合含税单价","小计",
                "订单总额","已收货数量","供应商名称","供应商编码","供应商含税单价","供应商不含税单价", "供应商小计","利润额"
        };
        util.exportExcel("报表",orderReconCloumn,excel,outStream,ExportExcelUtil.EXCEl_FILE_2007);
        outStream.flush();
        outStream.close();
    }

    @Override
    public void getAllExcel(HttpServletResponse response, IpOrderReconciliationSearchDto  orderReconciliationSearchDto)throws Exception {
        ExportExcelUtil<IpOrderReconciliationAllExcelVo> util = new ExportExcelUtil<>();
        List<IpOrderReconciliationAllExcelVo> allExcel = ipOrderReconciliationDtoMapper.getAllExcel(orderReconciliationSearchDto);
        String fileName = String.valueOf(System.currentTimeMillis()).substring(4, 13) + ".xlsx";
        String encode = URLEncoder.encode(fileName, "UTF-8");
        String headStr="attachment;filename=\"" + encode + "\"";
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition", headStr);
        response.addHeader("Content-type", "application-download");
        ServletOutputStream outStream = response.getOutputStream();
        String[] orderReconCloumn={
                "订单号","商品名称","商品编码","下单时间","下单方","订单数量","下单价格","税率","综合不含税单价","综合含税单价","小计",
               "订单总额","类型","已收货数量","供应商名称","供应商编码","供应商含税单价","供应商不含税单价", "供应商小计","利润额"
        };
        util.exportExcel("汇总明细",orderReconCloumn,allExcel,outStream,ExportExcelUtil.EXCEl_FILE_2007);
        outStream.flush();
        outStream.close();
    }

}
