package com.ekingwin.bas.cloud.monitor.web;

import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationCheckPageDto;
import com.ekingwin.bas.cloud.monitor.service.IpOrderReconciliationCheckService;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationCheckExcelVo;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping("/checkReconciliation")
@Api("已对账清单")
public class IpOrderReconciliationCheckController {
    @Autowired
    private IpOrderReconciliationCheckService ipOrderReconciliationCheckService;

    @RequestMapping(value = "/getCheckList",method = RequestMethod.POST)
    @ApiOperation(value = "获取字段列表")
    public Result getCheckList(@RequestBody IpOrderReconciliationCheckPageDto ipOrderReconciliationCheckPageDto)throws Exception{
        PageInfo pageInfo=ipOrderReconciliationCheckService.getCheckList(ipOrderReconciliationCheckPageDto);
        return Result.ok(pageInfo);
    }
    @RequestMapping(value = "/getCheckExcel",method = RequestMethod.POST)
    @ApiOperation(value = "表格导出")
    public void getCheckExcel( HttpServletResponse response, IpOrderReconciliationCheckExcelVo ipOrderReconciliationCheckExcelVo)throws Exception{
        ipOrderReconciliationCheckService.getCheckExcel(response,ipOrderReconciliationCheckExcelVo);
    }

}
