package com.ekingwin.bas.cloud.monitor.web;

import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationConfirmDto;
import com.ekingwin.bas.cloud.monitor.dto.IpOrderReconciliationSearchDto;
import com.ekingwin.bas.cloud.monitor.service.WaitingReconciliationService;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationTotalVo;
import com.ekingwin.bas.cloud.monitor.vo.IpOrderReconciliationVo;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

@RestController
@RequestMapping(value = "/waitingReconciliation/")
@Api(tags = "待对账", description = "待对账", value = "待对账")
public class WaitingReconciliationController {

    @Autowired
    private WaitingReconciliationService waitingReconciliationService;



    @PostMapping("/getOrderWaitingList")
    @ApiOperation(value = "查询对账列表", notes = "查询对账列表",response = IpOrderReconciliationVo.class )
    public Result getOrderWaitingList(@RequestBody IpOrderReconciliationSearchDto  orderReconciliationSearchDto) throws Exception{
        PageInfo<IpOrderReconciliationVo> pageInfo = waitingReconciliationService.getPageInfo(orderReconciliationSearchDto);
        return Result.ok(pageInfo);
    }

    @PostMapping("/getAllOrderReconciliation")
    @ApiOperation(value = "查询订单交易明细", notes = "查询订单交易明细",response = IpOrderReconciliationVo.class )
    public Result getAllOrderReconciliation(@RequestBody IpOrderReconciliationSearchDto  orderReconciliationSearchDto) throws Exception{
        PageInfo<IpOrderReconciliationVo> pageInfo = waitingReconciliationService.getAllOrderReconciliation(orderReconciliationSearchDto);
        return Result.ok(pageInfo);
    }

    @PostMapping("/confirmOrderWaiting")
    @ApiOperation(value = "对账确认", notes = "对账确认",response = IpOrderReconciliationVo.class )
    public Result confirmOrderWaiting(@RequestBody IpOrderReconciliationConfirmDto confirmDto) throws Exception{
        waitingReconciliationService.confirmOrderWaiting(confirmDto);
        return Result.ok();
    }

    @PostMapping("/getOrderTotal")
    @ApiOperation(value = "获取对账统计总额", notes = "获取对账统计总额",response = IpOrderReconciliationTotalVo.class )
    public Result getOrderTotal(@RequestBody IpOrderReconciliationSearchDto  orderReconciliationSearchDto) throws Exception{
        IpOrderReconciliationTotalVo orderTotal = waitingReconciliationService.getOrderTotal(orderReconciliationSearchDto);
        return Result.ok(orderTotal);
    }

    @PostMapping("/getOrderAllTotal")
    @ApiOperation(value = "获取汇总明细对账统计总额", notes = "获取对账统计总额",response = IpOrderReconciliationTotalVo.class )
    public Result getOrderAllTotal(@RequestBody IpOrderReconciliationSearchDto  orderReconciliationSearchDto) throws Exception{
        IpOrderReconciliationTotalVo orderTotal = waitingReconciliationService.getOrderAllTotal(orderReconciliationSearchDto);
        return Result.ok(orderTotal);
    }
    @RequestMapping(value = "/exportExcel",method = RequestMethod.POST)
    @ApiOperation(value = "待对账Excel导出")
    public void exportExcel (HttpServletResponse response, @RequestBody IpOrderReconciliationSearchDto  orderReconciliationSearchDto)throws Exception{
        waitingReconciliationService.getExcel(response,orderReconciliationSearchDto);
    }


    @RequestMapping(value = "/exportAllExcel",method = RequestMethod.POST)
    @ApiOperation(value = "订单明细汇总Excel导出")
    public void exportAllExcel (HttpServletResponse response, @RequestBody IpOrderReconciliationSearchDto  orderReconciliationSearchDto)throws Exception{
        waitingReconciliationService.getAllExcel(response,orderReconciliationSearchDto);
    }




}
