package com.ekingwin.bas.cloud.portal.dao;

import com.ekingwin.bas.cloud.portal.dto.*;
import com.ekingwin.bas.cloud.portal.vo.*;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface BusinessStatementDao {
    /**
     * 订单汇总
     * @param queryAllOrderVo
     * @return
     */
    List<QueryAllOrderDto> queryAllOrder(QueryAllOrderVo queryAllOrderVo);

    /**
     * 根据日期到期提醒
     * @param expirationRemindingVo
     * @return
     */
    List<ExpirationRemindingDto> expirationReminding(ExpirationRemindingVo expirationRemindingVo);

    /**
     * 采购额报表统计
     * @param queryAllPurchasesVo
     * @return
     */
    List<QueryAllPurchasesDto> queryAllPurchases(QueryAllPurchasesVo queryAllPurchasesVo);

    /**
     * 商品上下架统计
     * @param upAndDownListVo
     * @return
     */
    List<UpAndDownListDto> UpAndDownList(UpAndDownListVo upAndDownListVo);

    /**
     * 商品分类销售数量报表
     * @param catagorySaleVolumeVo
     * @return
     */
    List<GoodsCatagorySaleVolumeDto> queryAllgoodscatagorySaleVolume(GoodsCatagorySaleVolumeVo catagorySaleVolumeVo);

    /**
     * 商品评价汇总
     * @param goodsEvaluationsummaryVo
     * @return
     */
    List<GoodsEvaluationsummaryDto> querygoodsEvaluationsummary(GoodsEvaluationsummaryVo goodsEvaluationsummaryVo);

    /**
     * 查询战区
     * @param warZoneVo
     * @return
     */
    List<WarZoneDto> queryWarZone(WarZoneAndCompanyVo warZoneVo);


    /**
     * 根据战区查询战区联动公司
     * @param warZoneVo
     * @return
     */
    List<CompanyAndWarZoneDto> queryCompany(WarZoneAndCompanyVo warZoneVo);

    /**
     * 查询一级物资分类信息
     * @param ftnpCategoryNamesVo
     * @return
     */
    List<FTNPFirstCategoryNameDto> FTNPFirstCategoryName(FTNPCategoryNamesVo ftnpCategoryNamesVo);

    /**
     * 查询二级物资分类信息
     * @param ftnpCategoryNamesVo
     * @return
     */
    List<FTNPSecondCategoryNameDto> FTNPSecondCategoryName(FTNPCategoryNamesVo ftnpCategoryNamesVo);

    /**
     * 查询三级物资分类信息
     * @param ftnpCategoryNamesVo
     * @return
     */
    List<FTNPThreeCategoryNameDto> FTNPThreeCategoryName(FTNPCategoryNamesVo ftnpCategoryNamesVo);
}
