package com.ekingwin.bas.cloud.portal.dao;

import com.ekingwin.bas.cloud.user.dto.UserDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @program: rcworkspace
 * @description:主表信息修改
 * @author: zhangjie
 * @create: 2019-06-27 16:07
 **/
@Repository
public interface IPortalLoginUserDao {


    /**
     * 获取人员基本信息
     *
     * @param   userid
     * @return List<Map<String,Object>>
     * @throws Exception the exception
     */
    List<Map<String,Object>> getLoginUserBasicInfo(String userid) ;
    /**
     * 获取人员信息
     *
     * @param   userid
     * @return List<Map<String,Object>>
     * @throws Exception the exception
     */
    List<Map<String,Object>> getLoginUser(String userid) ;

    /**
     * 获取岗位id
     *
     * @param   userid
     * @return List<Map<String,Object>>
     * @throws Exception the exception
     */
    List<Map<String,Object>> getLoginUserPostionId(String id) ;
    /**
     * 获取部门
     *
     * @param   userid
     * @return List<Map<String,Object>>
     * @throws Exception the exception
     */
    List<Map<String,Object>> getLoginUserDeptInfo(@Param(value = "id")String id) ;
    /**
     * 获取公司
     *
     * @param   userid
     * @return List<Map<String,Object>>
     * @throws Exception the exception
     */
    List<Map<String,Object>> getLoginUserCompanyInfo(@Param(value = "id")String id) ;
    /**
     * 获取其他公司信息
     *
     * @param   userid
     * @return List<Map<String,Object>>
     * @throws Exception the exception
     */
    List<Map<String,Object>> getLoginUserOtherInfo(@Param(value = "id")String id) ;
    /**
     * 获取其他公司信息
     *
     * @param   userid
     * @return List<Map<String,Object>>
     * @throws Exception the exception
     */
    List<Map<String,Object>> getLoginUserOtherUpInfo() ;
    /**
     * 获取TaxNum
     *
     * @param   userid
     * @return List<Map<String,Object>>
     * @throws Exception the exception
     */
    List<Map<String,Object>> getLoginUserTaxNumInfo(@Param(value = "id")String id) ;
    /**
     * 获取区域
     *
     * @param   userid
     * @return List<Map<String,Object>>
     * @throws Exception the exception
     */
    List<Map<String,Object>> getLoginUserArgeareaInfo(@Param(value = "id")String id) ;

    UserDto get(String currentUserId);
}
