package com.ekingwin.bas.cloud.portal.dao;

import com.ekingwin.bas.cloud.portal.dto.PurchasingPlatformGoodsDto;
import com.ekingwin.bas.cloud.portal.dto.PurchasingPlatformSupplierDto;
import com.ekingwin.bas.cloud.portal.dto.UnitecodeDto;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformAddVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformGoodsVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformOrderAddVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformSupplierVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IPurchasingPlatformDao {
    /**
     * 供应商查询
     * @param purchasingPlatformVo
     * @return
     */
    List<PurchasingPlatformSupplierDto> queryPurchasingPlatformSupplier(PurchasingPlatformSupplierVo purchasingPlatformVo);

    /**
     * 商品查询
     * @param purchasingPlatformGoodsVo
     * @return
     */
    List<PurchasingPlatformGoodsDto> queryPurchasingPlatformGoods(PurchasingPlatformGoodsVo purchasingPlatformGoodsVo);

    /**
     * ip_c_drafts 草稿箱的添加操作
     * @param purchasingPlatformGoodsVo
     */
    void AddIpCDrafts(PurchasingPlatformAddVo purchasingPlatformGoodsVo);

    /**
     * 查询出草稿箱id
     * @param time
     * @return
     */
    Integer queryIpCDrafts(String time);

    /**
     * 查询seq当前值
     * @return
     */
    Integer queryipCOrderAllgoodsDrafts();


    /**
     * ip_c_order_allgoods_drafts添加数据
     * @param purchasingPlatformOrderAddVo
     */
    void AddipCOrderAllgoodsDrafts(PurchasingPlatformOrderAddVo purchasingPlatformOrderAddVo);

    /**
     * ip_c_order_drafts  添加数据
     * @param purchasingPlatformGoodsVo
     */
    void AddIpCOrderDrafts(PurchasingPlatformAddVo purchasingPlatformGoodsVo);

    /**
     * ip_c_order_drafts_attachment  添加附件部分
     * @param purchasingPlatformGoodsVo
     */
    void AddIpCOrderDraftsAttachment(PurchasingPlatformAddVo purchasingPlatformGoodsVo);


    /**
     * 查询Draftsid值是否已经存在过
     * @param purchasingPlatformGoodsVo
     * @return
     */
    Integer queryDraftsid(PurchasingPlatformAddVo purchasingPlatformGoodsVo);

    /**
     * ip_c_drafts 草稿箱的更新操作
     * @param purchasingPlatformGoodsVo
     */
    void updateIpCDrafts(PurchasingPlatformAddVo purchasingPlatformGoodsVo);

    /**
     * ip_c_order_allgoods_drafts更新数据
     * @param purchasingPlatformOrderAddVo
     */
    void UpdateipCOrderAllgoodsDrafts(PurchasingPlatformOrderAddVo purchasingPlatformOrderAddVo);

    /**
     * ip_c_order_drafts  更新数据
     * @param purchasingPlatformGoodsVo
     */
    void updateIpCOrderDrafts(PurchasingPlatformAddVo purchasingPlatformGoodsVo);

    /**
     * ip_c_order_drafts_attachment  更新附件部分
     * @param purchasingPlatformGoodsVo
     */
    void updateIpCOrderDraftsAttachment(PurchasingPlatformAddVo purchasingPlatformGoodsVo);


    /**
     * 查询收款账号
     * @param
     * @return
     */
    List<UnitecodeDto> queryunitecode(PurchasingPlatformSupplierDto purchasingPlatformSupplierDto);

}
