package com.ekingwin.bas.cloud.portal.service;

import com.ekingwin.bas.cloud.attachment.dto.FileObject;
import com.ekingwin.bas.cloud.portal.vo.*;
import com.github.pagehelper.PageInfo;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;

public interface IBusinessStatementService {
    /**
     * 订单汇总
     * @param queryAllOrderVo
     * @return
     */
    PageInfo  queryAllOrder(QueryAllOrderVo queryAllOrderVo);



    /**
     * 根据日期到期提醒
     * @param expirationRemindingVo
     * @return
     */
    PageInfo expirationReminding(ExpirationRemindingVo expirationRemindingVo);


    /**
     * 采购额报表统计
     * @param queryAllPurchasesVo
     * @return
     */
    PageInfo queryAllPurchases(QueryAllPurchasesVo queryAllPurchasesVo);

    /**
     * 商品上下架统计
     * @param upAndDownListVo
     * @return
     */
    PageInfo UpAndDownList(UpAndDownListVo upAndDownListVo);

    /**
     * 商品分类销售数量报表
     * @param catagorySaleVolumeVo
     * @return
     */
    PageInfo queryAllgoodscatagorySaleVolume(GoodsCatagorySaleVolumeVo catagorySaleVolumeVo);

    /**
     * 商品评价汇总
     * @param goodsEvaluationsummaryVo
     * @return
     */
    PageInfo querygoodsEvaluationsummary(GoodsEvaluationsummaryVo goodsEvaluationsummaryVo);

    /**
     * 查询战区
     * @param warZoneVo
     * @return
     */
    PageInfo queryWarZone(WarZoneAndCompanyVo warZoneVo);

    /**
     * 查询公司
     * @param warZoneVo
     * @return
     */
    PageInfo queryCompany(WarZoneAndCompanyVo warZoneVo);

    /**
     * 查询一级物资分类信息
     * @param ftnpCategoryNamesVo
     * @return
     */
    PageInfo FTNPFirstCategoryName(FTNPCategoryNamesVo ftnpCategoryNamesVo);

    /**
     * 查询二级物资分类信息
     * @param ftnpCategoryNamesVo
     * @return
     */
    PageInfo FTNPSecondCategoryName(FTNPCategoryNamesVo ftnpCategoryNamesVo);

    /**
     * 查询三级物资分类信息
     * @param ftnpCategoryNamesVo
     * @return
     */
    PageInfo FTNPThreeCategoryName(FTNPCategoryNamesVo ftnpCategoryNamesVo);


    /**
     * 订单汇总报表导出
     * @param
     * @param queryAllOrderVo
     * @return
     */
    HSSFWorkbook OrderExportReportExcel(QueryAllOrderVo queryAllOrderVo, HttpServletResponse response);
}
