package com.ekingwin.bas.cloud.portal.service;

import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformAddVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformGoodsVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformSupplierVo;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;

import java.io.InputStream;
import java.util.Map;

public interface IPurchasingPlatformService {

    /**
     * 供应商查询
     * @param purchasingPlatformVo
     * @return
     */
    PageInfo queryPurchasingPlatformSupplier(PurchasingPlatformSupplierVo purchasingPlatformVo);

    /**
     * 商品查询
     * @param purchasingPlatformGoodsVo
     * @return
     */
    PageInfo queryPurchasingPlatformGoods(PurchasingPlatformGoodsVo purchasingPlatformGoodsVo);

    /**
     * 费用化及专项采购保存
     * @param purchasingPlatformGoodsVo
     * @return
     */
    Result AddPurchasingPlatform(PurchasingPlatformAddVo purchasingPlatformGoodsVo);



    /**
     * FileUploading
     * @param name
     * @param inputStream
     * @return
     */
    Result FileUploading(InputStream inputStream, String name, Map<String, String[]> fileMeta);
}
