package com.ekingwin.bas.cloud.portal.service.impl;

import com.ekingwin.bas.cloud.portal.dao.BusinessStatementDao;
import com.ekingwin.bas.cloud.portal.dto.*;
import com.ekingwin.bas.cloud.portal.service.IBusinessStatementService;
import com.ekingwin.bas.cloud.portal.vo.*;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.poi.hssf.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Value;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Primary
@Service
public class BusinessStatementServiceImpl implements IBusinessStatementService {

    @Autowired
    private BusinessStatementDao businessStatementDao;

    @Value("${dataSourceName}")
    private String basUrlName;
    @Value("${dataSourceName3}")
    private String jiucaiyun_bas;
    @Value("${img.url}")
    private String url;
    @Value("${goods.targetDir}")
    private String fileDirPath;


    /**
     * 订单汇总
     *
     * @param queryAllOrderVo
     * @return
     */
    @Override
    public PageInfo queryAllOrder(QueryAllOrderVo queryAllOrderVo) {
        PageHelper.startPage(queryAllOrderVo.getPageNum(), queryAllOrderVo.getPageSize());
        queryAllOrderVo.setBasUrlName(basUrlName);
        List<QueryAllOrderDto> queryAllOrderDtos = businessStatementDao.queryAllOrder(queryAllOrderVo);
        PageInfo pageInfo = new PageInfo<>(queryAllOrderDtos);
        return pageInfo;


    }

    /**
     * 根据日期到期提醒
     *
     * @param expirationRemindingVo
     * @return
     */
    @Override
    public PageInfo expirationReminding(ExpirationRemindingVo expirationRemindingVo) {
        PageHelper.startPage(expirationRemindingVo.getPageNum(), expirationRemindingVo.getPageSize());
        expirationRemindingVo.setBasUrlName(basUrlName);
        expirationRemindingVo.setUrl(url);
        List<ExpirationRemindingDto> expirationRemindingDtos = businessStatementDao.expirationReminding(expirationRemindingVo);
        PageInfo pageInfo = new PageInfo<>(expirationRemindingDtos);
        return pageInfo;
    }

    /**
     * 采购额报表统计
     *
     * @param queryAllPurchasesVo
     * @return
     */
    @Override
    public PageInfo queryAllPurchases(QueryAllPurchasesVo queryAllPurchasesVo) {
        PageHelper.startPage(queryAllPurchasesVo.getPageNum(), queryAllPurchasesVo.getPageSize());
        List<QueryAllPurchasesDto> queryAllPurchasesDto = businessStatementDao.queryAllPurchases(queryAllPurchasesVo);
        PageInfo pageInfo = new PageInfo<>(queryAllPurchasesDto);
        return pageInfo;
    }

    /**
     * 商品上下架统计
     *
     * @param upAndDownListVo
     * @return
     */
    @Override
    public PageInfo UpAndDownList(UpAndDownListVo upAndDownListVo) {
        PageHelper.startPage(upAndDownListVo.getPageNum(), upAndDownListVo.getPageSize());
        upAndDownListVo.setBasUrlName(basUrlName);
        List<UpAndDownListDto> upAndDownListDtos = businessStatementDao.UpAndDownList(upAndDownListVo);
        PageInfo pageInfo = new PageInfo<>(upAndDownListDtos);
        return pageInfo;
    }

    /**
     * 商品分类销售数量报表
     *
     * @param catagorySaleVolumeVo
     * @return
     */
    @Override
    public PageInfo queryAllgoodscatagorySaleVolume(GoodsCatagorySaleVolumeVo catagorySaleVolumeVo) {

        PageHelper.startPage(catagorySaleVolumeVo.getPageNum(), catagorySaleVolumeVo.getPageSize());
        catagorySaleVolumeVo.setBasUrlName(basUrlName);
        List<GoodsCatagorySaleVolumeDto> goodsCatagorySaleVolumeDtos = businessStatementDao.queryAllgoodscatagorySaleVolume(catagorySaleVolumeVo);
        PageInfo pageInfo = new PageInfo<>(goodsCatagorySaleVolumeDtos);
        return pageInfo;
    }

    /**
     * 商品评价汇总
     *
     * @param goodsEvaluationsummaryVo
     * @return
     */
    @Override
    public PageInfo querygoodsEvaluationsummary(GoodsEvaluationsummaryVo goodsEvaluationsummaryVo) {
        PageHelper.startPage(goodsEvaluationsummaryVo.getPageNum(), goodsEvaluationsummaryVo.getPageSize());
        goodsEvaluationsummaryVo.setBasUrlName(basUrlName);
        goodsEvaluationsummaryVo.setJiucaiyun_bas(jiucaiyun_bas);
        List<GoodsEvaluationsummaryDto> goodsEvaluationsummaryDtos = businessStatementDao.querygoodsEvaluationsummary(goodsEvaluationsummaryVo);
        PageInfo pageInfo = new PageInfo<>(goodsEvaluationsummaryDtos);
        return pageInfo;
    }

    /**
     * 查询战区联动公司
     *
     * @param warZoneVo
     * @return
     */
    @Override
    public PageInfo queryWarZone(WarZoneAndCompanyVo warZoneVo) {
        PageHelper.startPage(warZoneVo.getPageNum(), warZoneVo.getPageSize());

        List<WarZoneDto> warZoneDtos = businessStatementDao.queryWarZone(warZoneVo);
        return new PageInfo<>(warZoneDtos);
    }

    /**
     * 查询公司
     *
     * @param warZoneVo
     * @return
     */
    @Override
    public PageInfo queryCompany(WarZoneAndCompanyVo warZoneVo) {
        PageHelper.startPage(warZoneVo.getPageNum(), warZoneVo.getPageSize());
        List<CompanyAndWarZoneDto> companyDtos = businessStatementDao.queryCompany(warZoneVo);
        return new PageInfo<>(companyDtos);
    }

    /**
     * 查询一级物资分类信息
     *
     * @param ftnpCategoryNamesVo
     * @return
     */
    @Override
    public PageInfo FTNPFirstCategoryName(FTNPCategoryNamesVo ftnpCategoryNamesVo) {
        PageHelper.startPage(ftnpCategoryNamesVo.getPageNum(), ftnpCategoryNamesVo.getPageSize());
        List<FTNPFirstCategoryNameDto> ftnpFirstCategoryNameDtos = businessStatementDao.FTNPFirstCategoryName(ftnpCategoryNamesVo);
        return new PageInfo<>(ftnpFirstCategoryNameDtos);
    }

    /**
     * 查询二级物资分类信息
     *
     * @param ftnpCategoryNamesVo
     * @return
     */
    @Override
    public PageInfo FTNPSecondCategoryName(FTNPCategoryNamesVo ftnpCategoryNamesVo) {
        PageHelper.startPage(ftnpCategoryNamesVo.getPageNum(), ftnpCategoryNamesVo.getPageSize());
        List<FTNPSecondCategoryNameDto> ftnpSecondCategoryName = businessStatementDao.FTNPSecondCategoryName(ftnpCategoryNamesVo);
        return new PageInfo<>(ftnpSecondCategoryName);
    }

    /**
     * 查询三级物资分类信息
     *
     * @param ftnpCategoryNamesVo
     * @return
     */
    @Override
    public PageInfo FTNPThreeCategoryName(FTNPCategoryNamesVo ftnpCategoryNamesVo) {
        PageHelper.startPage(ftnpCategoryNamesVo.getPageNum(), ftnpCategoryNamesVo.getPageSize());
        List<FTNPThreeCategoryNameDto> ftnpThreeCategoryName = businessStatementDao.FTNPThreeCategoryName(ftnpCategoryNamesVo);
        return new PageInfo<>(ftnpThreeCategoryName);
    }

    /**
     * 订单汇总报表导出
     *  @param queryAllOrderVo
     * @return
     */
    @Override
    public HSSFWorkbook OrderExportReportExcel(QueryAllOrderVo queryAllOrderVo,HttpServletResponse response) {
        if (queryAllOrderVo == null) {
            queryAllOrderVo = new QueryAllOrderVo();
        }
        queryAllOrderVo.setPageSize(100000);
        // 声明一个工作薄
        @SuppressWarnings("resource")
        HSSFWorkbook wb = new HSSFWorkbook();
        // 声明一个单子并命名
        HSSFSheet sheet = wb.createSheet("导出订单报表");
        // 给单子名称一个长度
        sheet.setDefaultColumnWidth((short) 15);
        // 生成一个样式
        HSSFCellStyle style = wb.createCellStyle();
        // 创建第一行（也可以称为表头）
        HSSFRow row = sheet.createRow(0);
        // 给表头第一行一次创建单元格
        HSSFCell cell = row.createCell((short) 0);
        cell.setCellValue("采购订单号");
        cell.setCellStyle(style);
        cell = row.createCell((short) 1);
        cell.setCellValue("EBS订单号");
        cell.setCellStyle(style);
        cell = row.createCell((short) 2);
        cell.setCellValue("商品编码");
        cell.setCellStyle(style);
        cell = row.createCell((short) 3);
        cell.setCellValue("商品一级分类");
        cell.setCellStyle(style);
        cell = row.createCell((short) 4);
        cell.setCellValue("商品二级分类");
        cell.setCellStyle(style);
        cell = row.createCell((short) 5);
        cell.setCellValue("商品三级分类");
        cell.setCellStyle(style);
        cell = row.createCell((short) 6);
        cell.setCellValue("商品名称");
        cell.setCellStyle(style);
        cell = row.createCell((short) 7);
        cell.setCellValue("商品类别");
        cell.setCellStyle(style);
        cell = row.createCell((short) 8);
        cell.setCellValue("品牌/型号/规格");
        cell.setCellStyle(style);
        cell = row.createCell((short) 9);
        cell.setCellValue("品名");
        cell.setCellStyle(style);
        cell = row.createCell((short) 10);
        cell.setCellValue("供应商名称");
        cell.setCellStyle(style);
        cell = row.createCell((short) 11);
        cell.setCellValue("供应商编码");
        cell.setCellStyle(style);
        cell = row.createCell((short) 12);
        cell.setCellValue("订单创建时间");
        cell.setCellStyle(style);
        cell = row.createCell((short) 13);
        cell.setCellValue("订单审批完成时间");
        cell.setCellStyle(style);
        cell = row.createCell((short) 14);
        cell.setCellValue("预计到货时间");
        cell.setCellStyle(style);
        cell = row.createCell((short) 15);
        cell.setCellValue("确认收货时间");
        cell.setCellStyle(style);
        cell = row.createCell((short) 16);
        cell.setCellValue("订单状态");
        cell.setCellStyle(style);
        cell = row.createCell((short) 17);
        cell.setCellValue("采购员");
        cell.setCellStyle(style);
        cell = row.createCell((short) 18);
        cell.setCellValue("所属部门");
        cell.setCellStyle(style);
        cell = row.createCell((short) 19);
        cell.setCellValue("公司编码");
        cell.setCellStyle(style);
        cell = row.createCell((short) 20);
        cell.setCellValue("战区");
        cell.setCellStyle(style);
        cell = row.createCell((short) 21);
        cell.setCellValue("公司名称");
        cell.setCellStyle(style);
        cell = row.createCell((short) 22);
        cell.setCellValue("采购数量");
        cell.setCellStyle(style);
        cell = row.createCell((short) 23);
        cell.setCellValue("单价(含税)");
        cell.setCellStyle(style);
        cell = row.createCell((short) 24);
        cell.setCellValue("税率(%)");
        cell.setCellStyle(style);
        cell = row.createCell((short) 25);
        cell.setCellValue("人民币小计");
        cell.setCellStyle(style);
        cell = row.createCell((short) 26);
        cell.setCellValue("本位币小计");
        cell.setCellStyle(style);
        cell = row.createCell((short) 27);
        cell.setCellValue("币种");
        cell.setCellStyle(style);
        cell = row.createCell((short) 28);
        cell.setCellValue("汇率");
        cell.setCellStyle(style);
        cell = row.createCell((short) 29);
        cell.setCellValue("关闭原因");
        cell.setCellStyle(style);
        cell = row.createCell((short) 30);
        cell.setCellValue("收货数量");
        cell.setCellStyle(style);

        try {
            queryAllOrderVo.setBasUrlName(basUrlName);
            List<QueryAllOrderDto> orderDtos = businessStatementDao.queryAllOrder(queryAllOrderVo);
            // 向单元格里填充数据
            for (int i = 0; i < orderDtos.size(); i++) {
                row = sheet.createRow(i + 1);
                row.createCell(0).setCellValue(orderDtos.get(i).getOrdernum()==null?"":orderDtos.get(i).getOrdernum());
                row.createCell(1).setCellValue(orderDtos.get(i).getPonum()==null?"":orderDtos.get(i).getPonum());
                row.createCell(2).setCellValue(orderDtos.get(i).getGoodsid()==null?"":orderDtos.get(i).getGoodsid());
                row.createCell(3).setCellValue(orderDtos.get(i).getFTNPFirstCategoryName()==null?"":orderDtos.get(i).getFTNPFirstCategoryName());
                row.createCell(4).setCellValue(orderDtos.get(i).getFTNPSecondCategoryName()==null?"":orderDtos.get(i).getFTNPSecondCategoryName());
                row.createCell(5).setCellValue(orderDtos.get(i).getFTNPThreeCategoryName()==null?"":orderDtos.get(i).getFTNPThreeCategoryName());
                row.createCell(6).setCellValue(orderDtos.get(i).getName()==null?"":orderDtos.get(i).getName());
                row.createCell(7).setCellValue(orderDtos.get(i).getMaterialclassify()==null?"":orderDtos.get(i).getMaterialclassify());
                row.createCell(8).setCellValue(orderDtos.get(i).getBrandname()==null?"":orderDtos.get(i).getBrandname());
                row.createCell(9).setCellValue(orderDtos.get(i).getCauseofclosure()==null?"":orderDtos.get(i).getCauseofclosure());
                row.createCell(10).setCellValue(orderDtos.get(i).getSupplier()==null?"":orderDtos.get(i).getSupplier());
                row.createCell(11).setCellValue(orderDtos.get(i).getSuppliernum()==null?"":orderDtos.get(i).getSuppliernum());
                row.createCell(12).setCellValue(orderDtos.get(i).getInputdate()==null?"":orderDtos.get(i).getInputdate());
                row.createCell(13).setCellValue(orderDtos.get(i).getAppproedate()==null?"":orderDtos.get(i).getAppproedate());
                row.createCell(14).setCellValue(orderDtos.get(i).getExpectdeliverydate()==null?"":orderDtos.get(i).getExpectdeliverydate());
                row.createCell(15).setCellValue(orderDtos.get(i).getDeliverydate()==null?"":orderDtos.get(i).getDeliverydate());
                row.createCell(16).setCellValue(orderDtos.get(i).getState()==null?"":orderDtos.get(i).getState());
                row.createCell(17).setCellValue(orderDtos.get(i).getCnname()==null?"":orderDtos.get(i).getCnname());
                row.createCell(18).setCellValue(orderDtos.get(i).getDeptname()==null?"":orderDtos.get(i).getDeptname());
                row.createCell(19).setCellValue(orderDtos.get(i).getCompanyid()==null?"":orderDtos.get(i).getCompanyid());
                row.createCell(20).setCellValue(orderDtos.get(i).getLargeareaname()==null?"":orderDtos.get(i).getLargeareaname());
                row.createCell(21).setCellValue(orderDtos.get(i).getCompanyname()==null?"":orderDtos.get(i).getCompanyname());
                row.createCell(22).setCellValue(orderDtos.get(i).getCount()==null?"":orderDtos.get(i).getCount());
                row.createCell(23).setCellValue(orderDtos.get(i).getPrice()==null?"":orderDtos.get(i).getPrice());
                row.createCell(24).setCellValue(orderDtos.get(i).getTaxrate()==null?"":orderDtos.get(i).getTaxrate());
                row.createCell(25).setCellValue(orderDtos.get(i).getTotalhsprice()==null?"":orderDtos.get(i).getTotalhsprice());
                row.createCell(26).setCellValue(orderDtos.get(i).getRmbtotalhsprice()==null?"":orderDtos.get(i).getRmbtotalhsprice());
                row.createCell(27).setCellValue(orderDtos.get(i).getCurrency()==null?"":orderDtos.get(i).getCurrency());
                row.createCell(28).setCellValue(orderDtos.get(i).getExchangerate()==null?"":orderDtos.get(i).getExchangerate());
                row.createCell(29).setCellValue(orderDtos.get(i).getBrand()==null?"":orderDtos.get(i).getBrand());
                row.createCell(30).setCellValue(orderDtos.get(i).getReceiptcount()==null?"":orderDtos.get(i).getReceiptcount());
            }
        } catch (
                Exception e1) {
            e1.printStackTrace();
        }
        try {

            File targetFile = new File(fileDirPath);
            if(!targetFile.exists()){
                targetFile.mkdirs();
            }
            SimpleDateFormat formatter= new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
            Date date = new Date(System.currentTimeMillis());
            String b = formatter.format(date);
            //String a = "订单汇总"+ b +".xls";
            String a = "订单汇总"+ b;
            //附件上传的全路径
//            String filePath = "D:"+"//" + a;
//            // 导出到指定位置下
            ServletOutputStream out = response.getOutputStream();
            response.reset();
            //中文名称要进行编码处理
            response.setHeader("Content-disposition", "attachment; filename="+new String(a.getBytes("GB2312"),"iso8859-1")+".xls");
            response.setContentType("application/msexcel");
            wb.write(out);
            out.close();
            return wb;
        } catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "导出成功!");
            e.printStackTrace();
        } catch (IOException e) {
            JOptionPane.showMessageDialog(null, "导出成功!");
            e.printStackTrace();
        }catch(HeadlessException e){
            e.printStackTrace();
        }
        return null;
    }
}

