package com.ekingwin.bas.cloud.portal.service.impl;


import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.portal.dao.IPortalAuthorityFrontDao;
import com.ekingwin.bas.cloud.portal.service.IPortalAuthorityFrontService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * The type Ip goods service.
 *
 * @program: rcworkspace
 * @description:
 * @author:
 * @create:
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class PortalAuthorityFrontServiceImpl extends BaseService implements IPortalAuthorityFrontService {

    private Logger logger = LoggerFactory.getLogger(PortalAuthorityFrontServiceImpl.class);


    @Autowired
    private IPortalAuthorityFrontDao iPortalAuthorityFrontDao;


    @Override
    public List<Map<String, Object>> getPortalAuthority(String  userid) throws Exception {
//        String userid=UserUtils.getCurrentUser().toLowerCase();
        List<Map<String, Object>> authorityRole = iPortalAuthorityFrontDao.getAuthorityRole(userid);
            if(authorityRole!=null && authorityRole.size()>0){
                List<Map<String, Object>> authorityRoleList = iPortalAuthorityFrontDao.getAuthorityRoleList(userid);
                return authorityRoleList;
            }else{
                List<Map<String, Object>> emptyAuthorityRole = iPortalAuthorityFrontDao.getEmptyAuthorityRole(userid);
                return emptyAuthorityRole;
            }
//        return null;
    }


}
