package com.ekingwin.bas.cloud.portal.service.impl;


import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.portal.dao.IPortalAuthorityFrontDao;
import com.ekingwin.bas.cloud.portal.dao.IPortalLoginUserDao;
import com.ekingwin.bas.cloud.portal.service.IPortalAuthorityFrontService;
import com.ekingwin.bas.cloud.portal.service.IPortalLoginUserService;
import com.ekingwin.bas.cloud.user.dto.UserDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The type Ip goods service.
 *
 * @program: rcworkspace
 * @description:
 * @author:
 * @create:
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class PortalLoginUserServiceImpl extends BaseService implements IPortalLoginUserService {

    private Logger logger = LoggerFactory.getLogger(PortalLoginUserServiceImpl.class);


    @Autowired
    private IPortalLoginUserDao iPortalLoginUserDao;


    @Override
    public Map<String, Object> getLoginUser(String userid) throws Exception {
        Map<String, Object> map =new HashMap<String, Object>();
        List<Map<String, Object>> position =new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> loginUserBasicInfo = iPortalLoginUserDao.getLoginUserBasicInfo(userid);
        if(loginUserBasicInfo!=null && loginUserBasicInfo.size()>0){
            map=loginUserBasicInfo.get(0);
            List<Map<String, Object>> loginUser = iPortalLoginUserDao.getLoginUser(userid);
            if(loginUser !=null && loginUser.size()>0){
                for(int i=0;i<loginUser.size();i++){
                    Map<String, Object> positions= loginUser.get(i);
                    List<Map<String, Object>> positionids = iPortalLoginUserDao.getLoginUserPostionId(positions.get("positionid") + "");
                    if(positionids!=null && positionids.size()>0){
                        String positionid= positionids.get(0).get("id")+"";
                        List<Map<String, Object>> loginUserDeptInfo = iPortalLoginUserDao.getLoginUserDeptInfo(positionid);
                        if(loginUserDeptInfo!=null && loginUserDeptInfo.size()>0){
                            positions.put("deptid",loginUserDeptInfo.get(0).get("deptid")+"");
                            positions.put("deptname",loginUserDeptInfo.get(0).get("deptname")+"");
                        }else{
                            positions.put("deptid","");
                            positions.put("deptname","");
                        }

                        List<Map<String, Object>> loginUserCompanyInfo = iPortalLoginUserDao.getLoginUserCompanyInfo(positionid);
                        if(loginUserCompanyInfo!=null && loginUserCompanyInfo.size()>0){
                            positions.put("companyid",loginUserCompanyInfo.get(0).get("companyid")+"");
                            positions.put("companyname",loginUserCompanyInfo.get(0).get("companyname")+"");
                            List<Map<String, Object>> othersid = iPortalLoginUserDao.getLoginUserOtherInfo(loginUserCompanyInfo.get(0).get("companyid") + "");
                            if(othersid!=null && othersid.size()>0){
                                if("10000050".equals(othersid.get(0).get("code")+"")){
                                    List<Map<String, Object>> loginUserOtherUpInfo = iPortalLoginUserDao.getLoginUserOtherUpInfo();
                                    if(loginUserOtherUpInfo!=null && loginUserOtherUpInfo.size()>0){
                                        positions.put("companyothersystemid","10000001");
                                    }else{
                                        positions.put("companyothersystemid","组织失败");
                                    }
                                }else{
                                    positions.put("companyothersystemid",othersid.get(0).get("othersystemid")+"");
                                }
                            }else{
                                positions.put("companyothersystemid","");
                            }

                            List<Map<String, Object>> taxnums = iPortalLoginUserDao.getLoginUserTaxNumInfo(loginUserCompanyInfo.get(0).get("companyid") + "");
                            if(taxnums!=null && taxnums.size()>0){
                                positions.put("taxnum",taxnums.get(0).get("taxnum")+"");
                            }else{
                                positions.put("taxnum","");
                            }

                        }else{
                            positions.put("companyid","");
                            positions.put("companyname","");
                        }


                        List<Map<String, Object>> loginUserArgeareaInfo = iPortalLoginUserDao.getLoginUserArgeareaInfo(positionid);
                        if(loginUserArgeareaInfo!=null  && loginUserArgeareaInfo.size()>0){
                            positions.put("largeareaid",loginUserArgeareaInfo.get(0).get("largeareaid")+"");
                            positions.put("largeareaname",loginUserArgeareaInfo.get(0).get("largeareaname")+"");
                        }else{
                            positions.put("largeareaid","");
                            positions.put("largeareaname","");
                        }

                    }

                    position.add(positions);
                }

             }
        }
        map.put("position",position);

        for(int i=0;i<position.size();i++){
            if("P".equals(position.get(i).get("ismainpost")+"")){
                map.put("positionid",position.get(i).get("positionid")+"");
                map.put("positionothersystemid",position.get(i).get("positionothersystemid")+"");
                map.put("positionname",position.get(i).get("positionname")+"");
                map.put("deptid",position.get(i).get("deptid")+"");
                map.put("deptname",position.get(i).get("deptname")+"");
                map.put("companyid",position.get(i).get("companyid")+"");
                map.put("companyothersystemid",position.get(i).get("companyothersystemid")+"");
                map.put("companyname",position.get(i).get("companyname")+"");
                map.put("taxnum",position.get(i).get("taxnum")+"");
            }
      /*      if(position[i].ismainpost=='P'){
                body.positionid=position[i].positionid
                body.positionothersystemid=position[i].positionothersystemid
                body.positionname=position[i].positionname
                body.deptid=position[i].deptid
                body.deptname=position[i].deptname
                body.companyid=position[i].companyid
                body.companyothersystemid=position[i].companyothersystemid
                body.companyname=position[i].companyname
                body.taxnum=position[i].taxnum
            }*/
        }
        return map;
    }

    @Override
    public UserDto get(String currentUserId) {
        UserDto serDtou= iPortalLoginUserDao.get(currentUserId);
        return null;
    }
}
