package com.ekingwin.bas.cloud.portal.service.impl;

import com.ekingwin.bas.cloud.attachment.dto.UploadFile;
import com.ekingwin.bas.cloud.dao.IpcCartMapper;
import com.ekingwin.bas.cloud.infra.utils.file.FileUtils;
import com.ekingwin.bas.cloud.portal.dao.IPurchasingPlatformDao;
import com.ekingwin.bas.cloud.portal.dto.DocFileDto;
import com.ekingwin.bas.cloud.portal.dto.PurchasingPlatformGoodsDto;
import com.ekingwin.bas.cloud.portal.dto.PurchasingPlatformSupplierDto;
import com.ekingwin.bas.cloud.portal.dto.UnitecodeDto;
import com.ekingwin.bas.cloud.portal.service.IPurchasingPlatformService;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformAddVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformGoodsVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformSupplierVo;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

@Primary
@Service
public class PurchasingPlatformServiceImpl implements IPurchasingPlatformService {

    @Value("${dataSourceName}")
    private String acrocessdatabase;
    @Value("${imageupload}")
    private String image_upload;
    @Value("${img.url}")
    private String img_url;

    @Autowired
    private IPurchasingPlatformDao purchasingPlatformDao;
    @Autowired
    private IpcCartMapper ipcCartMapper;

    /**
     * 供应商查询
     *
     * @param purchasingPlatformVo
     * @return
     */
    @Override
    public PageInfo queryPurchasingPlatformSupplier(PurchasingPlatformSupplierVo purchasingPlatformVo) {
        PageHelper.startPage(purchasingPlatformVo.getPagenum(), purchasingPlatformVo.getPagesize());
        purchasingPlatformVo.setName(acrocessdatabase);
        List<PurchasingPlatformSupplierDto> purchasingPlatformDtos = purchasingPlatformDao.queryPurchasingPlatformSupplier(purchasingPlatformVo);
        for (int i = 0; i < purchasingPlatformDtos.size(); i++) {
            purchasingPlatformDtos.get(i).setDatabase(acrocessdatabase);
            //查询收款账号
            List<UnitecodeDto> unitecodeDtos = purchasingPlatformDao.queryunitecode(purchasingPlatformDtos.get(i));
            for (int j = 0; j < unitecodeDtos.size(); j++) {
                unitecodeDtos.get(j).setLable(unitecodeDtos.get(j).getUnitecode());
                unitecodeDtos.get(j).setKey(i+"");
            purchasingPlatformDtos.get(i).setSubject(purchasingPlatformDtos.get(i).getId() + purchasingPlatformDtos.get(i).getFullname() +
                    purchasingPlatformDtos.get(i).getNum() + purchasingPlatformDtos.get(i).getAddress()+unitecodeDtos.get(j).getUnitecode());
            purchasingPlatformDtos.get(i).setUnitecode(unitecodeDtos);
            }
        }
        PageInfo pageInfo = new PageInfo<>(purchasingPlatformDtos);
        return pageInfo;
    }

    /**
     * 商品查询
     *
     * @param purchasingPlatformGoodsVo
     * @return
     */
    @Override
    public PageInfo queryPurchasingPlatformGoods(PurchasingPlatformGoodsVo purchasingPlatformGoodsVo) {
        PageHelper.startPage(purchasingPlatformGoodsVo.getPagenum(), purchasingPlatformGoodsVo.getPagesize());
        if (purchasingPlatformGoodsVo.getSupplierid() == null) {
            purchasingPlatformGoodsVo.setSupplierid("");
        }
        if (purchasingPlatformGoodsVo.getSupplierid().equals("")) {
            ArrayList list = new ArrayList<>();
            Result error = Result.error("请先选择供应商!");
            list.add(error);
            PageInfo pageInfo = new PageInfo<>(list);
            return pageInfo;
        }
        purchasingPlatformGoodsVo.setName(acrocessdatabase);
        List<PurchasingPlatformGoodsDto> platformGoodsDtos = purchasingPlatformDao.queryPurchasingPlatformGoods(purchasingPlatformGoodsVo);
        PageInfo pageInfo = new PageInfo<>(platformGoodsDtos);
        return pageInfo;
    }

    /**
     * 费用化及专项采购保存
     *
     * @param purchasingPlatformGoodsVo
     * @return
     */
    @Override
    public Result AddPurchasingPlatform(PurchasingPlatformAddVo purchasingPlatformGoodsVo) {
        //判断为空的bug
//        for (int i = 0; i < purchasingPlatformGoodsVo.getPlatformOrderAddVos().size(); i++) {
//            purchasingPlatformGoodsVo.setUserid(purchasingPlatformGoodsVo.getUserid() == null ? "" : purchasingPlatformGoodsVo.getUserid());
//        }

        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = d.format(date);
        purchasingPlatformGoodsVo.setCreatedate(time);
        if (purchasingPlatformGoodsVo.getType().equals("采购需求")) {
            purchasingPlatformGoodsVo.setType("R");
        } else if (purchasingPlatformGoodsVo.getType().equals("标准采购")) {
            purchasingPlatformGoodsVo.setType("BZ");
        } else if (purchasingPlatformGoodsVo.getType().equals("专项采购")) {
            purchasingPlatformGoodsVo.setType("FW");
        } else if (purchasingPlatformGoodsVo.getType().equals("费用化采购")) {
            purchasingPlatformGoodsVo.setType("FY");
        } else if (purchasingPlatformGoodsVo.getType().equals("退货")) {
            purchasingPlatformGoodsVo.setType("T");
        } else if (purchasingPlatformGoodsVo.getType().equals("换货")) {
            purchasingPlatformGoodsVo.setType("H");
        }
        if (purchasingPlatformGoodsVo.getDraftsid() == null || purchasingPlatformGoodsVo.getDraftsid().equals(0)) {
            purchasingPlatformGoodsVo.setDraftsid(0);
        }
        //查询Draftsid值是否已经存在过
        Integer count = purchasingPlatformDao.queryDraftsid(purchasingPlatformGoodsVo);
        if (count > 0) {
            //ip_c_drafts 草稿箱的更新操作
            try {
                purchasingPlatformDao.updateIpCDrafts(purchasingPlatformGoodsVo);
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("ip_c_drafts 草稿箱的添加操作失败");
            }
            for (int i = 0; i < purchasingPlatformGoodsVo.getPlatformOrderAddVos().size(); i++) {
                purchasingPlatformGoodsVo.getPlatformOrderAddVos().get(i).setDraftsid(purchasingPlatformGoodsVo.getDraftsid());
                try {
                //ip_c_order_allgoods_drafts更新数据
                    purchasingPlatformDao.UpdateipCOrderAllgoodsDrafts(purchasingPlatformGoodsVo.getPlatformOrderAddVos().get(i));
                } catch (Exception e) {
                    e.printStackTrace();
                    return Result.error("ip_c_order_allgoods_drafts更新数据失败");
                }
            }
            if (purchasingPlatformGoodsVo.getType().equals("R")) {
                purchasingPlatformGoodsVo.setType("采购需求");
            } else if (purchasingPlatformGoodsVo.getType().equals("BZ")) {
                purchasingPlatformGoodsVo.setType("标准采购");
            } else if (purchasingPlatformGoodsVo.getType().equals("FW")) {
                purchasingPlatformGoodsVo.setType("专项采购");
            } else if (purchasingPlatformGoodsVo.getType().equals("FY")) {
                purchasingPlatformGoodsVo.setType("费用化采购");
            } else if (purchasingPlatformGoodsVo.getType().equals("T")) {
                purchasingPlatformGoodsVo.setType("退货");
            } else if (purchasingPlatformGoodsVo.getType().equals("H")) {
                purchasingPlatformGoodsVo.setType("换货");
            }
            purchasingPlatformGoodsVo.setOrdertype(purchasingPlatformGoodsVo.getType());
            purchasingPlatformGoodsVo.setBuyer(purchasingPlatformGoodsVo.getUserid());
            purchasingPlatformGoodsVo.setState("审批中");
            purchasingPlatformGoodsVo.setSurfacetype("1");
            purchasingPlatformGoodsVo.setInputperson(purchasingPlatformGoodsVo.getUserid());
            purchasingPlatformGoodsVo.setInputdate(time);
            purchasingPlatformGoodsVo.setSender(purchasingPlatformGoodsVo.getSupplier());
            purchasingPlatformGoodsVo.setAddressee(purchasingPlatformGoodsVo.getReceiver() + "(" + purchasingPlatformGoodsVo.getUserid() + ")");

            try {
                //ip_c_order_drafts  更新数据
                purchasingPlatformDao.updateIpCOrderDrafts(purchasingPlatformGoodsVo);
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("ip_c_order_drafts  更新数据失败");
            }

            purchasingPlatformGoodsVo.setDocoldid(purchasingPlatformGoodsVo.getDocid());
            purchasingPlatformGoodsVo.setDocsystem("SYC");
            try {
                //ip_c_order_drafts_attachment  更新附件部分
                purchasingPlatformDao.updateIpCOrderDraftsAttachment(purchasingPlatformGoodsVo);
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("ip_c_order_drafts_attachment  更新附件部分失败");
            }
            return Result.ok("更新成功");
        } else {
            try {
            //ip_c_drafts 草稿箱的添加操作
                purchasingPlatformDao.AddIpCDrafts(purchasingPlatformGoodsVo);
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("ip_c_drafts 草稿箱的添加操作失败");
            }
            //查询出草稿箱id
            Integer draftsid = purchasingPlatformDao.queryIpCDrafts(time);
            purchasingPlatformGoodsVo.setDraftsid(draftsid);
            //查询seq当前值
            Integer seqq = purchasingPlatformDao.queryipCOrderAllgoodsDrafts();
            int seq = seqq + 1;
            for (int i = 0; i < purchasingPlatformGoodsVo.getPlatformOrderAddVos().size(); i++) {
                purchasingPlatformGoodsVo.getPlatformOrderAddVos().get(i).setSeq(seq);
                purchasingPlatformGoodsVo.getPlatformOrderAddVos().get(i).setDraftsid(draftsid);
                //ip_c_order_allgoods_drafts添加数据
                try {
                    purchasingPlatformDao.AddipCOrderAllgoodsDrafts(purchasingPlatformGoodsVo.getPlatformOrderAddVos().get(i));
                } catch (Exception e) {
                    e.printStackTrace();
                    return Result.error("ip_c_order_allgoods_drafts添加数据失败");
                }
            }
            if (purchasingPlatformGoodsVo.getType().equals("R")) {
                purchasingPlatformGoodsVo.setType("采购需求");
            } else if (purchasingPlatformGoodsVo.getType().equals("BZ")) {
                purchasingPlatformGoodsVo.setType("标准采购");
            } else if (purchasingPlatformGoodsVo.getType().equals("FW")) {
                purchasingPlatformGoodsVo.setType("专项采购");
            } else if (purchasingPlatformGoodsVo.getType().equals("FY")) {
                purchasingPlatformGoodsVo.setType("费用化采购");
            } else if (purchasingPlatformGoodsVo.getType().equals("T")) {
                purchasingPlatformGoodsVo.setType("退货");
            } else if (purchasingPlatformGoodsVo.getType().equals("H")) {
                purchasingPlatformGoodsVo.setType("换货");
            }
            purchasingPlatformGoodsVo.setSeq(seq);
            purchasingPlatformGoodsVo.setOrdertype(purchasingPlatformGoodsVo.getType());
            purchasingPlatformGoodsVo.setBuyer(purchasingPlatformGoodsVo.getUserid());
            purchasingPlatformGoodsVo.setState("审批中");
            purchasingPlatformGoodsVo.setSurfacetype("1");
            purchasingPlatformGoodsVo.setInputperson(purchasingPlatformGoodsVo.getUserid());
            purchasingPlatformGoodsVo.setInputdate(time);
            purchasingPlatformGoodsVo.setSender(purchasingPlatformGoodsVo.getSupplier());
            purchasingPlatformGoodsVo.setAddressee(purchasingPlatformGoodsVo.getReceiver() + "(" + purchasingPlatformGoodsVo.getUserid() + ")");
            try {
                //ip_c_order_drafts  添加数据
                purchasingPlatformDao.AddIpCOrderDrafts(purchasingPlatformGoodsVo);
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("ip_c_order_drafts  添加数据失败");
            }

            purchasingPlatformGoodsVo.setDocoldid(purchasingPlatformGoodsVo.getDocid());
            purchasingPlatformGoodsVo.setDocsystem("SYC");
            try {
                //ip_c_order_drafts_attachment  添加附件部分
                purchasingPlatformDao.AddIpCOrderDraftsAttachment(purchasingPlatformGoodsVo);
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("ip_c_order_drafts_attachment  添加附件部分失败");
            }
            if(("标准采购").equals(purchasingPlatformGoodsVo.getType())){
                try {
                    ipcCartMapper.deleteByCarIds(purchasingPlatformGoodsVo.getIds());
                } catch (Exception e) {
                    e.printStackTrace();
                    return Result.error("删除购物车失败");
                }
            }
            return Result.ok("保存成功");
        }
    }

    /**
     * 附件上传
     *
     * @param name
     * @param inputStream
     * @return
     */
    @Override
    public Result FileUploading(InputStream inputStream, String name, Map<String, String[]> fileMeta) {
        //附件上传
        String ext = "";
        int extPos = name.lastIndexOf(".");
        if (extPos != -1) {
            ext = name.substring(extPos + 1, name.length());
        }
        String fileGuid = UUID.randomUUID().toString();

        File file = new File(image_upload +"/"+ fileGuid + "." + ext);

        try {
            FileUtils.inputStreamToFile(inputStream, file);
        } catch (Exception e) {
            return Result.error("上传文件失败" + e.getMessage());
        }
        // 保存文件本体
        DocFileDto df = new DocFileDto();
        //封装文件属性
        df.setExtension(ext);
        df.setSize(file.length() + "");
        df.setPath(img_url+file.getPath());
        df.setFilename(file.getName());
        df.setDDocname(name);
        df.setAbspath(file.getAbsolutePath());

        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyyMMddHHmmss");
        time = d.format(date);
        df.setDocid(time);
        return Result.ok(df);

    }
}
