package com.ekingwin.bas.cloud.portal.web;

import com.ekingwin.bas.cloud.portal.service.IBusinessStatementService;
import com.ekingwin.bas.cloud.portal.vo.*;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/BusinessStatement")
@Api(tags = "业务报表",description = "业务报表", value = "业务报表")
public class BusinessStatementController {

    @Autowired
    private IBusinessStatementService businessStatementService;

    @PostMapping(value = "/queryAllOrder")
    @ApiOperation(value = "订单汇总", notes = "订单汇总")
    public Result queryAllOrder(@RequestBody QueryAllOrderVo queryAllOrderVo) throws Exception {
        PageInfo pageInfo = businessStatementService.queryAllOrder(queryAllOrderVo);
        return Result.ok(pageInfo);
    }

    @PostMapping(value = "/expirationReminding")
    @ApiOperation(value = "根据日期商品到期提醒", notes = "根据日期商品到期提醒")
    public Result expirationReminding(@RequestBody ExpirationRemindingVo expirationRemindingVo) {
        PageInfo pageInfo = businessStatementService.expirationReminding(expirationRemindingVo);
        return Result.ok(pageInfo);
    }

    @PostMapping(value = "/queryAllPurchases")
    @ApiOperation(value = "采购额报表统计", notes = "采购额报表统计")
    public Result queryAllPurchases(@RequestBody QueryAllPurchasesVo queryAllPurchasesVo) {
        PageInfo pageInfo = businessStatementService.queryAllPurchases(queryAllPurchasesVo);
        return Result.ok(pageInfo);
    }

    @PostMapping(value = "/UpAndDownList")
    @ApiOperation(value = "商品上下架统计", notes = "商品上下架统计")
    public Result UpAndDownList(@RequestBody UpAndDownListVo upAndDownListVo) {
        PageInfo pageInfo = businessStatementService.UpAndDownList(upAndDownListVo);
        return Result.ok(pageInfo);

    }
    @PostMapping(value = "/GoodsCatagorySaleVolumeList")
    @ApiOperation(value = "商品分类销售数量报表", notes = "商品分类销售数量报表")
    public Result GoodsCatagorySaleVolumeList(@RequestBody GoodsCatagorySaleVolumeVo catagorySaleVolumeVo) {
        PageInfo pageInfo = businessStatementService.queryAllgoodscatagorySaleVolume(catagorySaleVolumeVo);
        return Result.ok(pageInfo);

    }
    @PostMapping(value = "/goodsEvaluationsummary")
    @ApiOperation(value = "商品评价汇总", notes = "商品评价汇总")
    public Result goodsEvaluationsummary(@RequestBody GoodsEvaluationsummaryVo goodsEvaluationsummaryVo) {
        PageInfo pageInfo = businessStatementService.querygoodsEvaluationsummary(goodsEvaluationsummaryVo);
        return Result.ok(pageInfo);

    }
}
