package com.ekingwin.bas.cloud.portal.web;

import com.ekingwin.bas.cloud.portal.service.IBusinessStatementService;
import com.ekingwin.bas.cloud.portal.vo.QueryAllOrderVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

@CrossOrigin
@RestController
@RequestMapping(value = "/ExportReportExcel")
@Api(tags = "业务报表导出Excel", description = "业务报表导出Excel", value = "业务报表导出Excel")
public class ExportReportExcelController {

    @Autowired
    private IBusinessStatementService businessStatementService;

    @PostMapping(value = "/OrderExportReportExcel")
    @ApiOperation(value = "订单汇总报表导出", notes = "订单汇总报表导出")
    public HSSFWorkbook queryAllOrder(@RequestBody QueryAllOrderVo queryAllOrderVo, HttpServletResponse response) throws Exception {
       return businessStatementService.OrderExportReportExcel(queryAllOrderVo,response);

    }
}
