package com.ekingwin.bas.cloud.portal.web;

import com.ekingwin.bas.cloud.portal.service.IPortalAuthorityFrontService;
import com.ekingwin.bas.cloud.util.BackResult;
import com.ekingwin.bas.cloud.util.PublicJsonObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @program: rcworkspace
 * @description:
 * @author: zugs
 * @create:
 **/
@RestController
@RequestMapping(value = "/portal/authorityfront/")
@Api(tags = "首页", description = "首页", value = "首页")
public class PortalAuthorityFrontController {


    @Autowired
    private IPortalAuthorityFrontService portalAuthorityFrontService;


    @ApiOperation("得到权限列表")
    @RequestMapping(value = "/getPortalAuthority", method = RequestMethod.GET)
    public BackResult getPortalAuthority(@RequestParam(value = "userid") String userid) throws Exception{
        List<Map<String, Object>> portalAuthority = portalAuthorityFrontService.getPortalAuthority( userid);
        return PublicJsonObject.jsonObject(portalAuthority);
    }


}
