package com.ekingwin.bas.cloud.portal.web;

import com.ekingwin.bas.cloud.infra.utils.web.UserUtils;
import com.ekingwin.bas.cloud.portal.service.IPortalAuthorityFrontService;
import com.ekingwin.bas.cloud.portal.service.IPortalLoginUserService;
import com.ekingwin.bas.cloud.user.dto.UserDto;
import com.ekingwin.bas.cloud.util.BackResult;
import com.ekingwin.bas.cloud.util.PublicJsonObject;
import com.ekingwin.bas.cloud.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @program: rcworkspace
 * @description:
 * @author: zugs
 * @create:
 **/
@RestController
@RequestMapping(value = "/portal/loginuser/")
@Api(tags = "人员信息", description = "人员信息", value = "首页人员信息")
public class PortalLoginUserController {


    @Autowired
    private IPortalLoginUserService iPortalLoginUserService;

    /**
     * 获取人员-通威2.0
     * @return
     * @throws Exception
     */
    @ApiOperation("单点登录（废弃）")
    @RequestMapping(value = "/getCurrentFbcUser", method = RequestMethod.GET)
    public BackResult getCurrentFbcUser() throws Exception {
        String currentUserId = UserUtils.getCurrentUser();
        if(StringUtils.isNotEmpty(currentUserId)){
            UserDto userDto = iPortalLoginUserService.get(currentUserId);
            if("0".equals(userDto.getStatus())){
                currentUserId = "";
            }
        }
        return BackResult.successResponse(200, "查询成功", currentUserId);

    }

    @ApiOperation("获取人员信息")
    @RequestMapping(value = "/getLoginUser", method = RequestMethod.GET)
    public BackResult getLoginUser(@RequestParam(value = "userid") String userid) throws Exception{
        Map<String, Object> portalAuthority = iPortalLoginUserService.getLoginUser( userid);
        return PublicJsonObject.json(portalAuthority);
}


}
