package com.ekingwin.bas.cloud.portal.web;

import com.ekingwin.bas.cloud.infra.utils.web.WebUtils;
import com.ekingwin.bas.cloud.portal.service.IPurchasingPlatformService;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformAddVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformGoodsVo;
import com.ekingwin.bas.cloud.portal.vo.PurchasingPlatformSupplierVo;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.InputStream;
import java.util.Map;

@RestController
@RequestMapping(value = "/PurchasingPlatform")
@Api(tags = "费用化及专项采购",description = "费用化及专项采购", value = "费用化及专项采购")
public class PurchasingPlatformController {

    @Autowired
    private IPurchasingPlatformService purchasingPlatformService;

    @PostMapping(value = "/queryPurchasingPlatformSupplier")
    @ApiOperation(value = "供应商查询", notes = "供应商查询")
    public Result queryPurchasingPlatformSupplier(@RequestBody PurchasingPlatformSupplierVo purchasingPlatformVo) throws Exception {
        PageInfo pageInfo = purchasingPlatformService.queryPurchasingPlatformSupplier(purchasingPlatformVo);
        return Result.ok(pageInfo);
    }

    @PostMapping(value = "/queryPurchasingPlatformGoods")
    @ApiOperation(value = "商品查询", notes = "商品查询")
    public Result queryPurchasingPlatformGoods(@RequestBody PurchasingPlatformGoodsVo purchasingPlatformGoodsVo) throws Exception {
        PageInfo pageInfo = purchasingPlatformService.queryPurchasingPlatformGoods(purchasingPlatformGoodsVo);
        return Result.ok(pageInfo);
    }
    @PostMapping(value = "/AddPurchasingPlatform")
    @ApiOperation(value = "费用化及专项采购保存", notes = "费用化及专项采购保存")
    public Result AddPurchasingPlatform(@RequestBody PurchasingPlatformAddVo purchasingPlatformGoodsVo) throws Exception {
        return purchasingPlatformService.AddPurchasingPlatform(purchasingPlatformGoodsVo);
    }
    @PostMapping(value = "/FileUploading")
    @ApiOperation(value = "附件上传", notes = "附件上传")
    public Result FileUploading(@RequestParam(value = "file") MultipartFile file, @RequestParam(value = "name", required=false) String name) throws Exception {
        Map<String, String[]> fileMeta = WebUtils.getRequest().getParameterMap();
        if(StringUtils.isEmpty(name)){
            name = file.getOriginalFilename();
        }
        return purchasingPlatformService.FileUploading(file.getInputStream(), name, fileMeta);
    }
}
