package com.ekingwin.bas.cloud.portal.web;

import com.ekingwin.bas.cloud.portal.dto.FTNPFirstCategoryNameDto;
import com.ekingwin.bas.cloud.portal.service.IBusinessStatementService;
import com.ekingwin.bas.cloud.portal.vo.FTNPCategoryNamesVo;
import com.ekingwin.bas.cloud.portal.vo.WarZoneAndCompanyVo;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/QueryAllPurchases")
@Api(tags = "采购额报表统计里的子接口",description = "采购额报表统计里的子接口", value = "采购额报表统计里的子接口")
public class QueryAllPurchasesController {

    @Autowired
    private IBusinessStatementService businessStatementService;

    @PostMapping(value = "/queryWarZone")
    @ApiOperation(value = "查询战区联动公司", notes = "查询战区联动公司")
    public Result queryWarZone (@RequestBody WarZoneAndCompanyVo warZoneVo) {
        PageInfo pageInfo = businessStatementService.queryWarZone(warZoneVo);
        return Result.ok(pageInfo);
    }
    @PostMapping(value = "/queryCompany")
    @ApiOperation(value = "查询公司", notes = "查询公司")
    public Result queryCompany (@RequestBody WarZoneAndCompanyVo warZoneVo) {
        PageInfo pageInfo = businessStatementService.queryCompany(warZoneVo);
        return Result.ok(pageInfo);
    }

    @PostMapping(value = "/FTNPFirstCategoryName")
    @ApiOperation(value = "查询一级物资分类信息", notes = "查询一级物资分类信息")
    public Result FTNPFirstCategoryName (@RequestBody FTNPCategoryNamesVo ftnpCategoryNamesVo) {
        PageInfo pageInfo = businessStatementService.FTNPFirstCategoryName(ftnpCategoryNamesVo);
        return Result.ok(pageInfo);
    }
    @PostMapping(value = "/FTNPSecondCategoryName")
    @ApiOperation(value = "查询二级物资分类信息", notes = "查询二级物资分类信息")
    public Result FTNPSecondCategoryName (@RequestBody FTNPCategoryNamesVo ftnpCategoryNamesVo) {
        PageInfo pageInfo = businessStatementService.FTNPSecondCategoryName(ftnpCategoryNamesVo);
        return Result.ok(pageInfo);
    }
    @PostMapping(value = "/FTNPThreeCategoryName")
    @ApiOperation(value = "查询三级物资分类信息", notes = "查询三级物资分类信息")
    public Result FTNPThreeCategoryName (@RequestBody FTNPCategoryNamesVo ftnpCategoryNamesVo) {
        PageInfo pageInfo = businessStatementService.FTNPThreeCategoryName(ftnpCategoryNamesVo);
        return Result.ok(pageInfo);
    }
}
