package com.ekingwin.bas.cloud.process.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

@Data
@ApiModel("流程发起需要的参数信息")
public class CreateProcessDto {
    @ApiModelProperty(value = "用户登录账号", required = true)
    private String userId;
    @ApiModelProperty(value = "流程建模名称", required = true)
    private String processName;
    @ApiModelProperty(value = "主题", required = false)
    private String subject;
    @ApiModelProperty(value = "流程发起时的签字意见", required = false)
    private String comment;
    @ApiModelProperty(value = "流程参数", required = false)
    private Map<String, Object> businessData;
    @ApiModelProperty(value = "申请单号", required = false)
    private String reqNo;
    @ApiModelProperty(value = "固定值（97e13531669ebf79036fef457d2e26a5）", required = false)
    protected String sign;
    @ApiModelProperty(value = "租户ID（固定值:”BM_NGSP_WEB”）", required = false)
    protected String sysId;

    @ApiModelProperty(value = "业务主键")
    private String businessId;
}