package com.ekingwin.bas.cloud.process.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("获取审批列表需要的信息")
public class TodoListDto {

    @ApiModelProperty(value = "用户登录账号", required = true)
    private String userId;
    @ApiModelProperty(value = "实例ID(根据流程实例和userId可获取具体代办任务)", required = false)
    private String instanceId;
    @ApiModelProperty(value = "流程建模名称", required = false)
    private String processName;
    @ApiModelProperty(value = "页码，默认是1", required = false)
    private int pageNo;
    @ApiModelProperty(value = "每页显示个数，默认是20，最大为500", required = false)
    private int pageSize;
    @ApiModelProperty(value = "固定值（97e13531669ebf79036fef457d2e26a5）", required = false)
    protected String sign;
    @ApiModelProperty(value = "租户ID（固定值:”BM_NGSP_WEB”）", required = false)
    protected String sysId;
    @ApiModelProperty(value = "主题（主题+userId 模糊查询）", required = false)
    protected String subject;

}