package com.ekingwin.bas.cloud.process.service;

import com.ekingwin.bas.cloud.process.dto.*;

import java.util.List;

/**
 *
 * @description:流程服务相关接口
 * @author: huangyl
 * @create: 2019-07-03 10:28
 **/
public interface IpcProcessService {


    /**
     * 流程启动
     * @param createProcessDto
     * @return
     * @throws Exception
     */
    public  String createProcess(CreateProcessDto createProcessDto) throws Exception;
    /**
     * 流程审批
     * @param approvetaskDto
     * @return
     * @throws Exception
     */
    public  String approveTask(ApprovetaskDto approvetaskDto) throws Exception;


    /**
     * 获取代办列表
     * @param todoListDto
     * @return PageInfo
     * @throws Exception
     */
    ResultProcessTodoListDto getTodolist(TodoListDto todoListDto) throws Exception;

    /**
     * 获取审批记录列表
     * @param approveRecordDto
     * @return
     * @throws Exception
     */
    List<ApprovalReson> getApproveRecordsByInstanceId(ApproveRecordDto approveRecordDto) throws Exception;
    /**
     * 根据instanceId获取流程状态
     * @param
     * @return
     * @throws Exception
     */
    String getStauts(String instid) throws Exception;

    /**
     * 获取流程跟踪列表
     * @param processTrackingListDto
     * @return
     * @throws Exception
     */
    ResultProcessTrackingListDto getProcessTrackingList(ProcessTrackingListDto processTrackingListDto) throws Exception;


    /**
     * 终止流程
     * @param cancelProcessDto
     * @return
     * @throws Exception
     */
    public  String cancelProcess(CancelProcessDto cancelProcessDto) throws Exception;


}
