package com.ekingwin.bas.cloud.process.service.impl;

import com.ekingwin.bas.cloud.dao.ProcessInstanceMapper;
import com.ekingwin.bas.cloud.entity.ProcessInstance;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.process.dto.*;
import com.ekingwin.bas.cloud.process.service.IpcProcessService;
import com.ekingwin.bas.cloud.process.service.ProcessStautsService;
import com.ekingwin.bas.cloud.util.HttpXmlClient;
import com.ekingwin.bas.cloud.util.StringUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

/**
 * 有关于业务调用流程引擎接口公共服务实现类
 */
@Service
@Primary
public class IpcProcessServiceImpl implements IpcProcessService {


    private Logger logger = LoggerFactory.getLogger(IpcProcessServiceImpl.class);
    /**
     * 创建流程地址
     */
    @Value("${createProcessUrl}")
    private String createProcessUrl;

    /**
     * 流程审批
     */
    @Value("${approvetask}")
    private String approvetask;

    /**
     * 获取待办
     */
    @Value("${todoListUrl}")
    private String todoListUrl;

    /**
     * 获取审批记录
     */
    @Value("${approveRecordList}")
    private String approveRecordList;

    /**
     * 根据流程实例号获取待办
     */
    @Value("${processTrackingList}")
    private String processTrackingList;

    /**
     * 获取流程状态
     */
    @Value("${getProcessStauts}")
    private String getProcessStauts;

    /**
     * 根据流程实例号获取审批待办
     */
    @Value("${getTaskid}")
    private String getTaskid;

    /**
     * 根据流程实例号取消流程
     */
    @Value("${cancelProcess}")
    private String cancelProcess;

    /**
     * 调用bpm授权信息
     */
    @Value("${sysId}")
    private String sysId;

    /**
     * 调用bpm授权信息
     */
    @Value("${sign}")
    private String sign;

    @Autowired
    @Qualifier(value = "processStautsServiceImpl")
    private ProcessStautsService processStautsService;



    @Autowired
    private ProcessInstanceMapper processInstanceMapper;

    /**
     * 调用流程引擎发起流程
     * @param createProcessDto
     * @return
     * @throws Exception
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = Exception.class,isolation = Isolation.DEFAULT)
    public String createProcess(CreateProcessDto createProcessDto) throws Exception {
        createProcessDto.setSign(sign);
        createProcessDto.setSysId(sysId);
        JSONObject jsonResult = JSONObject.fromObject(createProcessDto);
        String result =  HttpXmlClient.post1(jsonResult.toString(),createProcessUrl);
        JSONObject jsonObject=JSONObject.fromObject(result);
        logger.info("调用流程引擎发起参数："+jsonResult.toString());
        String status = (String) jsonObject.get("status");
        //200代表流程引擎发起成功
        if("200".equals(status)){
            JSONObject jsonObjects =JSONObject.fromObject(jsonObject.get("data"));
            String instanceId = (String) jsonObjects.get("instanceId");
            ProcessInstance processInstance = new ProcessInstance();
            processInstance.setId(UUID.randomUUID().toString());
            processInstance.setInstanceid(instanceId);
            processInstance.setProcessid("1");
            processInstance.setSubject(createProcessDto.getSubject());
            processInstance.setProcessname(createProcessDto.getProcessName());
            processInstance.setApplyuserid(createProcessDto.getUserId());
            processInstance.setApplydate(new Date());
            processInstance.setBusinessid(createProcessDto.getBusinessId());
            processInstance.setStatus("审批中");
            processInstanceMapper.insert(processInstance);
            return  instanceId;
        }else {
            logger.error("流程发起失败："+jsonObject.get("msg").toString());
            throw  new BusinessException(500,jsonObject.get("msg").toString());
        }
    }

    /**
     * 流程审批公共服务
     * @param approvetaskDto
     * @return
     * @throws Exception
     */
    @Override
    public  String approveTask(ApprovetaskDto approvetaskDto) throws Exception{
        approvetaskDto.setSign(sign);
        approvetaskDto.setSysId(sysId);
        String instid =approvetaskDto.getInstid();
        String peocessName=approvetaskDto.getProcessName();
        String taskid= approvetaskDto.getTaskId();
        String comment = approvetaskDto.getComment();
        if(StringUtils.isEmpty(taskid)){
            //根据instanceid 获取taskid；
            taskid =getTaskidByInstanceId(instid);
            approvetaskDto.setTaskId(taskid);
        }
        approvetaskDto.setInstid("");
        approvetaskDto.setProcessName("");
        JSONObject jsonResult = JSONObject.fromObject(approvetaskDto);
        String result =  HttpXmlClient.post1(jsonResult.toString(),approvetask);
        JSONObject jsonObject=JSONObject.fromObject(result);
        //获取流程状态
        String status = (String) jsonObject.get("status");
        if(status.equals("200")){
/*            JSONObject jsonObjects =JSONObject.fromObject(jsonObject.get("data"));
            String taskId = (String) jsonObjects.get("taskId");*/
            //审批成功后查看流程状态
           String stats = getStauts(instid);
           //修改bas_basic_instance表里流程的状态
            processInstanceMapper.updateStrutsByInstanceId(stats,instid);
           ProcessInstance processInstance = new ProcessInstance();
            logger.info("流程审批状态"+instid+" 状态："+stats);
            //流程已审批完成
           if("已完成".equals(stats)){
               String action = approvetaskDto.getAction();
               //判断流程的审批结果，为不同意
               if("noAgreed".equals(action)){
                   //更改业务的状态为审批不通过
                   processStautsService.stautsIsNoAgreed(instid,peocessName,comment);
               }else{
                   //更改业务的审批状态为通过
                   processStautsService.stautsIsAgreed(instid,peocessName);

               }
           }else if ("终止".equals(stats)){
               //流程状态为终止，更改业务状态为审批不通过
               processStautsService.stautsIsNoAgreed(instid,peocessName,comment);
           }
            return  taskid;
        }else {
            throw  new BusinessException(500,jsonObject.get("msg").toString());
        }
    }

    /***
     * 获取待办列表
     * @param todoListDto
     * @return
     * @throws Exception
     */
    @Override
    public ResultProcessTodoListDto getTodolist(TodoListDto todoListDto) throws Exception {
        todoListDto.setSign(sign);
        todoListDto.setSysId(sysId);
        JSONObject jsonResult = JSONObject.fromObject(todoListDto);
        String result =  HttpXmlClient.post1(jsonResult.toString(),todoListUrl);
        JSONObject jsonObject=JSONObject.fromObject(result);
        String status = (String) jsonObject.get("status");
        if(status.equals("200")){
            JSONObject jsonObjects =(JSONObject)jsonObject.get("data");
            ResultProcessTodoListDto ss = new ResultProcessTodoListDto();
            ss.setPageCount(jsonObjects.get("pageCount").toString());
            ss.setTotal(jsonObjects.get("total").toString());
            ss.setPageSize(jsonObjects.get("pageSize").toString());
            List<TodoListReturnDto> todoListReturnDtoList = new ArrayList<>();
            JSONArray jsonArray=JSONArray.fromObject(jsonObjects.get("taskInfos"));
            if (jsonArray !=null && jsonArray.size()>0){
                for (Object o : jsonArray) {
                    TodoListReturnDto todoListReturn=(TodoListReturnDto)JSONObject.toBean((JSONObject) o,TodoListReturnDto.class);
                    todoListReturnDtoList.add(todoListReturn);
                }
                ss.setTaskInfos(todoListReturnDtoList);
            }
            return ss;
        }else {
            throw  new BusinessException(500,jsonObject.get("msg").toString());
        }
    }

    /**
     * 获取审批记录
     * @param approveRecordDto
     * @return
     * @throws Exception
     */
    @Override
    public List<ApprovalReson> getApproveRecordsByInstanceId(ApproveRecordDto approveRecordDto) throws Exception {
        approveRecordDto.setSign(sign);
        JSONObject jsonResult = JSONObject.fromObject(approveRecordDto);
        String result =  HttpXmlClient.post1(jsonResult.toString(),approveRecordList);
       JSONObject jsonObject=JSONObject.fromObject(result);
        String status=jsonObject.get("status").toString();
        if(status.equals("200")){
            List<ApprovalReson> approvalResonList = new ArrayList<>();
            JSONObject jsonObjects =(JSONObject)jsonObject.get("data");
            JSONArray jsonArray=JSONArray.fromObject(jsonObjects.get("approveRecords"));
            if (jsonArray !=null && jsonArray.size()>0){
                for (Object o : jsonArray) {
                    ApprovalReson approvalReson=(ApprovalReson)JSONObject.toBean((JSONObject) o,ApprovalReson.class);
                    String approvalAction =approvalReson.getApproveAction();
                    if(approvalAction.equals("agreed")){
                        approvalAction="同意";
                    }
                    approvalReson.setApproveAction(approvalAction);
                    approvalResonList.add(approvalReson);
                }
            }
            return approvalResonList;
        }else {
            throw  new BusinessException(500,jsonObject.get("msg").toString());
        }
    }

    /**
     * 获取流程的审批状态
     * @param instid
     * @return
     * @throws Exception
     */
    @Override
    public String getStauts(String instid) throws Exception {
        String result =  HttpXmlClient.post1(instid,getProcessStauts+instid);
        JSONObject jsonObject=JSONObject.fromObject(result);
        return  jsonObject.get("processStatus").toString();
    }


    /**
     * 根据流程实例号获取流程任务ID
     * @param instanceId
     * @return
     * @throws Exception
     */
    private String getTaskidByInstanceId(String instanceId) throws Exception {
        String result =  HttpXmlClient.post1(instanceId,getTaskid+instanceId);
        JSONObject jsonObject=JSONObject.fromObject(result);
        return  jsonObject.get("taskid").toString();
    }

    /**
     * 获取已办列表
     * @param processTrackingListDto
     * @return
     * @throws Exception
     */
    @Override
    public ResultProcessTrackingListDto getProcessTrackingList(ProcessTrackingListDto processTrackingListDto) throws Exception {
        processTrackingListDto.setSign(sign);
        processTrackingListDto.setSysId(sysId);
        JSONObject jsonResult = JSONObject.fromObject(processTrackingListDto);
        String result =  HttpXmlClient.post1(jsonResult.toString(),processTrackingList);
        JSONObject jsonObject=JSONObject.fromObject(result);
        String status=jsonObject.get("status").toString();
        if(status.equals("200")){
            List<TaskInfos> taskInfosList = new ArrayList<>();
            JSONObject jsonObjects =(JSONObject)jsonObject.get("data");
            ResultProcessTrackingListDto ss = new ResultProcessTrackingListDto();
            ss.setPageCount(jsonObjects.get("pageCount").toString());
            ss.setTotal(jsonObjects.get("total").toString());
            ss.setPageSize(jsonObjects.get("pageSize").toString());
            JSONArray jsonArray=JSONArray.fromObject(jsonObjects.get("taskInfos"));
            if (jsonArray !=null && jsonArray.size()>0){
                for (Object o : jsonArray) {
                    TaskInfos taskInfos=(TaskInfos)JSONObject.toBean((JSONObject) o,TaskInfos.class);
                    String reqTime=taskInfos.getReqTime();
                    reqTime=reqTime.substring(0,19);
                    taskInfos.setReqTime(reqTime);
                    taskInfosList.add(taskInfos);
                }
            }
            ss.setTaskInfos(taskInfosList);
            return ss;
        }else {
            throw  new BusinessException(500,jsonObject.get("msg").toString());
        }
    }

    /**
     * 流程作废与终止
     * @param cancelProcessDto
     * @return
     * @throws Exception
     */
    @Override
    public String cancelProcess(CancelProcessDto cancelProcessDto) throws Exception {
        cancelProcessDto.setSign(sign);
        cancelProcessDto.setSysId(sysId);
        String processName = cancelProcessDto.getProcessNme();
        String userId = cancelProcessDto.getUserId();
        String comment = cancelProcessDto.getComment();
        if (StringUtils.isEmpty(comment)){
            comment="不同意";
        }
        cancelProcessDto.setProcessNme("");
        JSONObject jsonResult = JSONObject.fromObject(cancelProcessDto);
        jsonResult.put("userId",userId+","+comment);
        String result =  HttpXmlClient.post1(jsonResult.toString(),cancelProcess);
        JSONObject jsonObject=JSONObject.fromObject(result);
        //修改bas_basic_instance表里流程的状态
        processInstanceMapper.updateStrutsByInstanceId("终止",cancelProcessDto.getInstanceId());
        //流程引擎作废
        processStautsService.stautsIsNoAgreed(cancelProcessDto.getInstanceId(),processName,cancelProcessDto.getComment());
        return  jsonObject.get("msg").toString();
    }

}
