package com.ekingwin.bas.cloud.process.service.impl;

import com.ekingwin.bas.cloud.dao.ProcessInstanceMapper;
import com.ekingwin.bas.cloud.entity.ProcessInstance;
import com.ekingwin.bas.cloud.process.service.ProcessStautsService;
import com.ekingwin.bas.cloud.rabbit.sender.ProcessSender;
import com.ekingwin.bas.cloud.service.IpOrderReceiverService;
import com.ekingwin.bas.cloud.service.IpcOrderService;
import com.ekingwin.bas.cloud.util.HttpXmlClient;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;


@Service
@Primary
public class ProcessStautsServiceImpl implements ProcessStautsService {

    private Logger logger = LoggerFactory.getLogger(ProcessStautsServiceImpl.class);
    @Autowired
    private IpcOrderService ipcOrderService;

    @Autowired
    private IpOrderReceiverService ipOrderReceiverService;

    @Autowired
    ProcessSender processSender;

    @Autowired
    private ProcessInstanceMapper processInstanceMapper;

    @Value("${bpm.goodsapproval}")
    private String goodsUrl;

    /**
     * 流程审批通过处理业务逻辑
     * @param instanceid
     * @param processName
     * @throws Exception
     */
    @Override
    public void stautsIsAgreed(String instanceid,String processName) throws Exception {
            //业务逻辑由调用者实现
        logger.info("处理流程通过：processName="+processName+",instanceid="+instanceid);

        if (processName.equals("CGXDSQLC")){
            //采购下单
            ipcOrderService.updatePassStatus(instanceid);
        }else  if (processName.equals("QRSH")){
            //确认收货
            ipOrderReceiverService.initPass(instanceid);
        }else  if (processName.equals("SPSXJLC")){
            //商品上下架
            JSONObject jsonObject = new JSONObject();
            jsonObject.element("instid",instanceid);
            jsonObject.element("processStatus","PASS");
            HttpXmlClient.post1(jsonObject.toString(),goodsUrl);
        }else  if (processName.equals("AgreementProcess")){
            //协议确认
            ProcessInstance processInstance = processInstanceMapper.selectByInstanceId(instanceid);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("contractId",processInstance.getBusinessid());
            jsonObject.put("intfType","01");
            JSONArray jsonArray = new JSONArray();
            jsonArray.add(jsonObject);
            logger.info("jsonArray = " + jsonArray);
            processSender.send("send.sapgoods.info",jsonArray.toString());
        }
    }

    /**
     *  流程审批不通过调用业务逻辑
     * @param instanceid
     * @param processName
     * @param comment
     * @throws Exception
     */
    @Override
    public void stautsIsNoAgreed(String instanceid,String processName,String comment) throws Exception {
        //业务逻辑由调用者实现
        logger.info("处理流程不通过：processName="+processName+",instanceid="+instanceid);
        if (processName.equals("CGXDSQLC")){
            //采购下单
            ipcOrderService.updateFailStatus(instanceid);
        }else if (processName.equals("SPSXJLC")){
            //商品上下架
            JSONObject jsonObject = new JSONObject();
            jsonObject.element("instid",instanceid);
            jsonObject.element("processStatus","FAIL");
            HttpXmlClient.post1(jsonObject.toString(),goodsUrl);
        }else  if (processName.equals("QRSH")){
            //确认收货
            ipOrderReceiverService.initFail(instanceid);
        }else  if (processName.equals("AgreementProcess")){
            //协议确认
            ProcessInstance processInstance = processInstanceMapper.selectByInstanceId(instanceid);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("contractId",processInstance.getBusinessid());
            jsonObject.put("intfType","02");
            jsonObject.put("rejectReason",comment);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add(jsonObject);
            logger.info("jsonArray = " + jsonArray);
            processSender.send("send.sapgoods.info",jsonArray.toString());
        }
    }
}
