package com.ekingwin.bas.cloud.process.web;


import com.ekingwin.bas.cloud.infra.web.BaseController;
import com.ekingwin.bas.cloud.process.dto.*;
import com.ekingwin.bas.cloud.process.service.IpcProcessService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/process/")
@Api(tags = "流程相关操作", description = "流程相关操作", value = "流程")
public class ProcessController extends BaseController{
	@Autowired
	@Qualifier(value="ipcProcessServiceImpl")
	private IpcProcessService ipcProcessService;

	@PostMapping("/create")
	@ApiOperation(value = "发起流程", notes = "发起流程")
	public Result createProcess(@RequestBody CreateProcessDto createProcessDto) throws Exception {
		String instanceId =ipcProcessService.createProcess(createProcessDto);
		return Result.ok(instanceId);
	}
	@PostMapping("/approvetask")
	@ApiOperation(value = "流程审批", notes = "流程审批")
	public Result approveTask(@RequestBody ApprovetaskDto approvetaskDto) throws Exception {
		//获取审批操作类型
		String action =approvetaskDto.getAction();
		if(action.equals("agreed") || action.equals("noAgreed")){
			//同意和退回
			String taskId =ipcProcessService.approveTask(approvetaskDto);
			return Result.ok(taskId);
		}else if(action.equals("cancelBtn")){
			//流程终止
			String instid=approvetaskDto.getInstid();
			String userId=approvetaskDto.getUserId();
			String processName = approvetaskDto.getProcessName();
			if(StringUtils.isEmpty(instid) || StringUtils.isEmpty(userId) || StringUtils.isEmpty(processName)){
				throw  new Exception("必填参数不能为空");
			}else{
				CancelProcessDto cancelProcessDto = new CancelProcessDto();
				cancelProcessDto.setInstanceId(instid);
				cancelProcessDto.setUserId(userId);
				cancelProcessDto.setProcessNme(processName);
				cancelProcessDto.setComment(approvetaskDto.getComment());
				String mas =ipcProcessService.cancelProcess(cancelProcessDto);
				Map<String,Object> map = new HashMap<>();
				map.put("data",mas);
				return Result.ok(map);
			}
		}
		return  null;
	}

	@PostMapping("/todolist")
	@ApiOperation(value = "获取审批列表", notes = "获取代办列表",response = TodoListReturnDto.class)
	public Result todolist(@RequestBody TodoListDto todoListDto) throws Exception{
		ResultProcessTodoListDto object=ipcProcessService.getTodolist(todoListDto);
		return Result.ok(object);
	}
	@PostMapping("/getApproveRecordsByInstanceId")
	@ApiOperation(value = "获取流程审批记录列表", notes = "获取流程审批记录列表",response = ApprovalReson.class)
	public Result getApproveRecordsByInstanceId(@RequestBody ApproveRecordDto approveRecordDto) throws Exception{
		List<ApprovalReson>  approvalResonList=ipcProcessService.getApproveRecordsByInstanceId(approveRecordDto);
		return Result.ok(approvalResonList);

	}
	@PostMapping("/getProcessStauts/{instid}")
	@ApiOperation(value = "获取流程状态", notes = "获取流程状态")
	public Result getStauts(@PathVariable(value = "instid")String instid) throws Exception{
		String  processStatus = ipcProcessService.getStauts(instid);
		Map<String,Object> map = new HashMap<>();
		map.put("processStatus",processStatus);
		return Result.ok(map);
	}

	@PostMapping("/processtrackinglist")
	@ApiOperation(value = "流程跟踪列表", notes = "流程跟踪列表",response = TaskInfos.class)
	public Result todolist(@RequestBody ProcessTrackingListDto processTrackingListDto) throws Exception{
		ResultProcessTrackingListDto object=ipcProcessService.getProcessTrackingList(processTrackingListDto);
		return Result.ok(object);
	}






}
