package com.ekingwin.bas.cloud.purchase.service.impl;

import com.ekingwin.bas.cloud.purchase.dao.DropdownframeDao;
import com.ekingwin.bas.cloud.purchase.dto.*;
import com.ekingwin.bas.cloud.purchase.service.DropdownframeService;
import com.ekingwin.bas.cloud.purchase.vo.InterfaceVo;
import com.ekingwin.bas.cloud.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName DropdownframeServiceImpl.java
 * @Description TODO
 * @createTime 2020/3/12 14:35
 */
@Service
@Primary
public class DropdownframeServiceImpl implements DropdownframeService {
@Autowired
private DropdownframeDao dropdownframedao;
    @Value("${dataSourceName}")
    private String basUrl;
    @Value("${dataSourceName2}")
    private String basUrl2;

    @Override
    public List<Map<String, Object>> getinterface(InterfaceVo interfaceVo) {
        List<Map<String,Object>> result=new ArrayList<>();
        Map<String,Object> map=new HashMap<>();
        if("currency".equals(interfaceVo.getEnfieldname())){
            if(StringUtils.isNotEmpty(interfaceVo.getParameter())){
                if("1".equals(interfaceVo.getParameter())){
                    SimpleDateFormat formatter=new SimpleDateFormat("yyyy-MM-dd");
                    String currentDate = formatter.format(new Date());
                    List<CurrencyDto> currencylist=dropdownframedao.getinterface1(currentDate);
                    if(currencylist!=null && !currencylist.isEmpty()){
                        for(int i=0;i<currencylist.size();i++){
                            result.get(i).put(currencylist.get(i).getFromcurrency(),currencylist.get(i).getFromcurrencyname());
                        }
                        map.put("CNY","CNY人民币");
                        result.add(map);
                    }else{
                        map.put("CNY","CNY人民币");
                        result.add(map);
                    }
                    return result;
            }else{
                    map.put("CNY","CNY人民币");
                    map.put("USD","USD美元");
                    map.put("SGD","SGD新加坡");
                    map.put("VND","VND越南盾");
                    map.put("TK","TK塔卡");
                    map.put("IDR","IDR印尼盾");
                    result.add(map);

            }
                return result;
        }else{
                map.put("CNY","CNY人民币");
                map.put("USD","USD美元");
                map.put("SGD","SGD新加坡");
                map.put("VND","VND越南盾");
                map.put("TK","TK塔卡");
                map.put("IDR","IDR印尼盾");
                result.add(map);
            }
            return result;
        }else if("aftersalesinstallation".equals(interfaceVo.getEnfieldname())){
            map.put("付费","付费");
            map.put("免费","免费");
            map.put("无","无");
        }else if("buyer".equals(interfaceVo.getEnfieldname())){
            List<BuyerDto> buyerList =dropdownframedao.getbuyer();
            if(buyerList!=null && !buyerList.isEmpty()){
                for(int i = 0; i<buyerList.size(); i++){
                    map.put(buyerList.get(i).getUserid(),buyerList.get(i).getUsername());
                    result.add(map);
                }
            }
            return result;
        }else if("receivablesaccount".equals(interfaceVo.getEnfieldname())){
            String parameter=interfaceVo.getParameter();
            if(StringUtils.isNotEmpty(parameter)){
               List<SupplierDto> supplierList = dropdownframedao.getbankaccount(parameter,basUrl);
               if(supplierList!=null && !supplierList.isEmpty()){
                   for(int i = 0; i<supplierList.size(); i++){
                       map.put(supplierList.get(i).getAccount().toString(),supplierList.get(i).getAccount());
                       result.add(map);
                   }
               }
            }
            return result;
        }else if("receivableaddress".equals(interfaceVo.getEnfieldname())){
            String parameter=interfaceVo.getParameter();
            List<ShipAddressDto> shipAddressList =dropdownframedao.getshipAddress(parameter);
            if(shipAddressList!=null && !shipAddressList.isEmpty()){
                for(int i=0;i<shipAddressList.size();i++) {
                    map.put("id", shipAddressList.get(i).getId());
                    map.put("deliveryaddress", shipAddressList.get(i).getAddress());
                    map.put("companyid", shipAddressList.get(i).getCompanycode());
                    map.put("type",shipAddressList.get(i).getType() );
                    result.add(map);
                }
            }
            return result;
        }else if("FTNPThreeCategoryName".equals(interfaceVo.getEnfieldname())){
            List<GoodsCategoryDto> goodsCategoryList =dropdownframedao.getgoodsCategory();
            if(goodsCategoryList!=null && !goodsCategoryList.isEmpty()){
                for(int i=0 ;i<goodsCategoryList.size();i++){
                    map.put(goodsCategoryList.get(i).getMdmid(),goodsCategoryList.get(i).getName());
                    result.add(map);
                }
            }
            return result;
        }else if("billingaddresscode".equals(interfaceVo.getEnfieldname())){
            map.put("5661","联合汽车电子有限公司");
            map.put("5662","联合汽车电子有限公司无锡厂");
            map.put("5663","联合汽车电子有限公司西安厂");
            map.put("5664","联合汽车电子有限公司重庆分公司");
            map.put("5665","联合汽车电子有限公司芜湖分公司");
            map.put("5666","联合汽车电子有限公司柳州分公司");
            result.add(map);
            return  result;

        }else if("factorycode".equals(interfaceVo.getEnfieldname())){
            map.put("5661","上海厂");
            map.put("5662","无锡厂");
            map.put("5663","西安厂");
            map.put("5664","重庆分公司");
            map.put("5665","芜湖厂");
            map.put("5666","柳州厂");
            result.add(map);
            return  result;
        }else if("goodsclassification".equals(interfaceVo.getEnfieldname())){
            map.put("A类","A类");
            map.put("K类","K类");
            map.put("F类","F类");
            map.put("S类","S类");
            result.add(map);
            return result;
        }else if("costfactor".equals(interfaceVo.getEnfieldname())){
            map.put("9990060173","办公用品摊销");
            map.put("9990060176","劳防用品摊销");
            result.add(map);
            return result;
        }else if("taxrate".equals(interfaceVo.getEnfieldname())){
            map.put("16","16");
            map.put("13","13");
            map.put("10","10");
            map.put("9","9");
            map.put("6'","6");
            map.put("5","5");
            map.put("3","3");
            map.put("0","0");
            result.add(map);
            return result;
        }else if("invoicetype".equals(interfaceVo.getEnfieldname())){
            map.put("1","普通发票");
            map.put("2","增值税专用发票");
            result.add(map);
            return result;
        }else if("pricetype".equals(interfaceVo.getEnfieldname())){
            map.put("到厂价'","到厂价");
            map.put("到站价","到站价");
            map.put("到港价","到港价");
            map.put("自提价","自提价");
            result.add(map);
            return result;
        }else if("yorn".equals(interfaceVo.getEnfieldname())){
            map.put("N","否");
            map.put("Y","是");
            result.add(map);
            return result;
        }else if("nory".equals(interfaceVo.getEnfieldname())){
            map.put("N","否");
            map.put("Y","是");
            result.add(map);
            return result;
        }
        return result;
    }
}
