package com.ekingwin.bas.cloud.purchase.service.impl;


import com.ekingwin.bas.cloud.purchase.dao.IpPurchaseOrderDao;
import com.ekingwin.bas.cloud.purchase.dto.*;
import com.ekingwin.bas.cloud.purchase.service.IpPurchaseOrderService;
import com.ekingwin.bas.cloud.purchase.vo.InterfaceVo;
import com.ekingwin.bas.cloud.purchase.vo.IpPurchaseOrderVo;
import com.ekingwin.bas.cloud.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName IpPurchaseOrderServiceImpl.java
 * @Description TODO
 * @createTime 2020/3/10 19:34
 */
@Service
@Primary
public class IpPurchaseOrderServiceImpl implements IpPurchaseOrderService {
@Autowired
private IpPurchaseOrderDao ipPurchaseOrderDao;
    @Value("${dataSourceName}")
    private String basUrl;
    @Value("${dataSourceName2}")
    private String basUrl2;
    @Value("${base.url}")
    private String baseUrl;

    @Override
    public Map<String, Object> getpurchaseOrderList() {
        List<IpPurchaseOrderDto> list= ipPurchaseOrderDao.getpurchaseOrderList();
        Map<String, Object> result = new HashMap<String, Object>();
        List<IpPurchaseOrderDto> result1=new ArrayList<>();
        List<IpPurchaseOrderDto> result2=new ArrayList<>();
        if(list!=null && list.size()>0){
            for(int i=0;i<list.size();i++){
                if("public".equals(list.get(i).getPart())){
                    result1.add(list.get(i));
                }else if("form".equals(list.get(i).getPart())){
                    result2.add(list.get(i));
        }
    }
            result.put("part1",result1);
            result.put("part2",result2);
        }
        return result;
    }

    @Override
    public OrderGoodsDto getbyprocessnum(String ordernum) {
        OrderGoodsDto orderGoodsDto=null;
        ipPurchaseOrderDao.updateipcorder(ordernum);
        List<OrderGoodsDto> list=ipPurchaseOrderDao.getordermsg(ordernum);
        if(list!=null && !list.isEmpty()){
            orderGoodsDto=list.get(0);
        }
        String companycode=orderGoodsDto.getCompanyid();
        if(StringUtils.isNotEmpty(companycode)){
            List<CompanyDto> companyList= ipPurchaseOrderDao.getordercompany(companycode);
            if(companyList!=null && companyList.size()>0){
                orderGoodsDto.setInvoicetitle(companyList.get(0).getInvoicetitle());
                orderGoodsDto.setTaxnumber(companyList.get(0).getTaxnum());
                orderGoodsDto.setUnitaddress(companyList.get(0).getUnitaddress());
                orderGoodsDto.setSphone(companyList.get(0).getTelephone());
                orderGoodsDto.setDepositbank(companyList.get(0).getOpenbank());
                orderGoodsDto.setAccount(companyList.get(0).getOpenbankaccount());
            }else{
                orderGoodsDto.setInvoicetitle("");
                orderGoodsDto.setTaxnumber("");
                orderGoodsDto.setUnitaddress("");
                orderGoodsDto.setSphone("");
                orderGoodsDto.setDepositbank("");
                orderGoodsDto.setAccount("");
            }
        }
        GoodsDto goodsDto=ipPurchaseOrderDao.getGoodsmsg(ordernum,basUrl,baseUrl,basUrl2);
        if(null!=goodsDto){
            List<GoodsDto> goods=new ArrayList<>();
            goods.add(goodsDto);
            orderGoodsDto.setGoods(goods);
        }else{
            orderGoodsDto.setGoods(null);
        }
        return orderGoodsDto;
    }

}
